/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    private static final Token EOF = new Token(-4, null);
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    private static final String WHITE = " \t\n\r";
    private String _delimiters;
    private String _header;
    private boolean _skip;
    private int pos;

    public HeaderTokenizer(String header) {
        this(header, RFC822);
    }

    public HeaderTokenizer(String header, String delimiters) {
        this(header, delimiters, true);
    }

    public HeaderTokenizer(String header, String delimiters, boolean skipComments) {
        this._skip = skipComments;
        this._header = header;
        this._delimiters = delimiters;
    }

    public String getRemainder() {
        return this._header.substring(this.pos);
    }

    public Token next() throws ParseException {
        return this.readToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token peek() throws ParseException {
        int start = this.pos;
        try {
            Token token = this.readToken();
            return token;
        }
        finally {
            this.pos = start;
        }
    }

    private Token readAtomicToken() {
        int start = this.pos;
        while (++this.pos < this._header.length() && this._delimiters.indexOf(this._header.charAt(this.pos)) == -1) {
        }
        return new Token(-1, this._header.substring(start, this.pos));
    }

    private Token readToken() throws ParseException {
        if (this.pos >= this._header.length()) {
            return EOF;
        }
        char c = this._header.charAt(this.pos);
        if (c == '(') {
            Token comment = this.readUntil(')', -3);
            if (this._skip) {
                return this.readToken();
            }
            return comment;
        }
        if (c == '\"') {
            return this.readUntil('\"', -2);
        }
        if (WHITE.indexOf(c) != -1) {
            this.eatWhiteSpace();
            return this.readToken();
        }
        if (this._delimiters.indexOf(c) != -1) {
            ++this.pos;
            return new Token(-1, String.valueOf(c));
        }
        return this.readAtomicToken();
    }

    private Token readUntil(char end, int type) {
        int start = ++this.pos;
        while (++this.pos < this._header.length() && this._header.charAt(this.pos) != end) {
        }
        String value = this._header.substring(start, this.pos++);
        return new Token(type, value);
    }

    private void eatWhiteSpace() {
        while (++this.pos < this._header.length() && WHITE.indexOf(this._header.charAt(this.pos)) != -1) {
        }
    }

    public static class Token {
        public static final int ATOM = -1;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        public static final int QUOTEDSTRING = -2;
        private int _type;
        private String _value;

        public Token(int type, String value) {
            this._type = type;
            this._value = value;
        }

        public int getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }
    }
}

