/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.message.Message;

public class Permutations {
    private Object[] in;
    private Object[] out;
    private int n;
    private int m;
    private int[] index;
    private boolean hasNext = true;

    public Permutations(Object[] in, Object[] out) {
        this(in, out, in.length);
    }

    public Permutations(Object[] in, Object[] out, int m) {
        this.n = in.length;
        this.m = m;
        if (this.n < m || m < 0) {
            throw Message.getInternalError("n < m or m < 0");
        }
        this.in = in;
        this.out = out;
        this.index = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.index[i] = i;
        }
        this.reverseAfter(m - 1);
    }

    private void moveIndex() {
        int i = this.rightmostDip();
        if (i < 0) {
            this.hasNext = false;
            return;
        }
        int leastToRightIndex = i + 1;
        for (int j = i + 2; j < this.n; ++j) {
            if (this.index[j] >= this.index[leastToRightIndex] || this.index[j] <= this.index[i]) continue;
            leastToRightIndex = j;
        }
        int t = this.index[i];
        this.index[i] = this.index[leastToRightIndex];
        this.index[leastToRightIndex] = t;
        if (this.m - 1 > i) {
            this.reverseAfter(i);
            this.reverseAfter(this.m - 1);
        }
    }

    private int rightmostDip() {
        for (int i = this.n - 2; i >= 0; --i) {
            if (this.index[i] >= this.index[i + 1]) continue;
            return i;
        }
        return -1;
    }

    private void reverseAfter(int i) {
        int start = i + 1;
        for (int end = this.n - 1; start < end; ++start, --end) {
            int t = this.index[start];
            this.index[start] = this.index[end];
            this.index[end] = t;
        }
    }

    public boolean next() {
        if (!this.hasNext) {
            return false;
        }
        for (int i = 0; i < this.m; ++i) {
            this.out[i] = this.in[this.index[i]];
        }
        this.moveIndex();
        return true;
    }
}

