/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.CompressNo;
import org.h2.compress.Compressor;
import org.h2.compress.LZFInputStream;
import org.h2.compress.LZFOutputStream;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class CompressTool {
    private static CompressTool instance = new CompressTool();
    private static byte[] buffer;
    private static final int MAX_BUFFER_SIZE = 0x4000000;

    private static byte[] getBuffer(int min) {
        if (min > 0x4000000) {
            return new byte[min];
        }
        if (buffer == null || buffer.length < min) {
            buffer = new byte[min];
        }
        return buffer;
    }

    private CompressTool() {
    }

    public static CompressTool getInstance() {
        return instance;
    }

    public byte[] compress(byte[] in, String algorithm) throws SQLException {
        int len = in.length;
        if (in.length < 5) {
            algorithm = "NO";
        }
        Compressor compress = this.getCompressor(algorithm);
        byte[] buff = CompressTool.getBuffer((len < 100 ? len + 100 : len) * 2);
        int newLen = this.compress(in, in.length, compress, buff);
        byte[] out = new byte[newLen];
        System.arraycopy(buff, 0, out, 0, newLen);
        return out;
    }

    public synchronized int compress(byte[] in, int len, Compressor compress, byte[] out) {
        int newLen = 0;
        out[0] = (byte)compress.getAlgorithm();
        int start = 1 + this.writeInt(out, 1, len);
        newLen = compress.compress(in, len, out, start);
        if (newLen > len + start || newLen <= 0) {
            out[0] = 0;
            System.arraycopy(in, 0, out, start, len);
            newLen = len + start;
        }
        return newLen;
    }

    public byte[] expand(byte[] in) throws SQLException {
        byte algorithm = in[0];
        Compressor compress = this.getCompressor(algorithm);
        try {
            int len = this.readInt(in, 1);
            int start = 1 + this.getLength(len);
            byte[] buff = new byte[len];
            compress.expand(in, start, in.length - start, buff, 0, len);
            return buff;
        }
        catch (Throwable e) {
            throw Message.getSQLException(90104, null, e);
        }
    }

    public void expand(byte[] in, byte[] out, int outPos) throws SQLException {
        byte algorithm = in[0];
        Compressor compress = this.getCompressor(algorithm);
        try {
            int len = this.readInt(in, 1);
            int start = 1 + this.getLength(len);
            compress.expand(in, start, in.length - start, out, outPos, len);
        }
        catch (Throwable e) {
            throw Message.getSQLException(90104, null, e);
        }
    }

    private int readInt(byte[] buff, int pos) {
        int x;
        if ((x = buff[pos++] & 0xFF) < 128) {
            return x;
        }
        if (x < 192) {
            return ((x & 0x3F) << 8) + (buff[pos++] & 0xFF);
        }
        if (x < 224) {
            return ((x & 0x1F) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
        }
        if (x < 240) {
            return ((x & 0xF) << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
        }
        return ((buff[pos++] & 0xFF) << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
    }

    private int writeInt(byte[] buff, int pos, int x) {
        if (x < 0) {
            buff[pos++] = -16;
            buff[pos++] = (byte)(x >> 24);
            buff[pos++] = (byte)(x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 5;
        }
        if (x < 128) {
            buff[pos++] = (byte)x;
            return 1;
        }
        if (x < 16384) {
            buff[pos++] = (byte)(0x80 | x >> 8);
            buff[pos++] = (byte)x;
            return 2;
        }
        if (x < 0x200000) {
            buff[pos++] = (byte)(0xC0 | x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 3;
        }
        if (x < 0x10000000) {
            buff[pos++] = (byte)(0xE0 | x >> 24);
            buff[pos++] = (byte)(x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 4;
        }
        buff[pos++] = -16;
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)x;
        return 5;
    }

    private int getLength(int x) {
        if (x < 0) {
            return 5;
        }
        if (x < 128) {
            return 1;
        }
        if (x < 16384) {
            return 2;
        }
        if (x < 0x200000) {
            return 3;
        }
        if (x < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private Compressor getCompressor(String algorithm) throws SQLException {
        if (algorithm == null) {
            algorithm = "LZF";
        }
        int idx = algorithm.indexOf(32);
        String options = null;
        if (idx > 0) {
            options = algorithm.substring(idx + 1);
            algorithm = algorithm.substring(0, idx);
        }
        int a = this.getCompressAlgorithm(algorithm);
        Compressor compress = this.getCompressor(a);
        compress.setOptions(options);
        return compress;
    }

    public int getCompressAlgorithm(String algorithm) throws SQLException {
        if ("NO".equals(algorithm = StringUtils.toUpperEnglish(algorithm))) {
            return 0;
        }
        if ("LZF".equals(algorithm)) {
            return 1;
        }
        if ("DEFLATE".equals(algorithm)) {
            return 2;
        }
        throw Message.getSQLException(90103, algorithm);
    }

    private Compressor getCompressor(int algorithm) throws SQLException {
        switch (algorithm) {
            case 0: {
                return new CompressNo();
            }
            case 1: {
                return new CompressLZF();
            }
            case 2: {
                return new CompressDeflate();
            }
        }
        throw Message.getSQLException(90103, "" + algorithm);
    }

    public static OutputStream wrapOutputStream(OutputStream out, String compressionAlgorithm, String entryName) throws SQLException {
        try {
            if ("GZIP".equals(compressionAlgorithm)) {
                out = new GZIPOutputStream(out);
            } else if ("ZIP".equals(compressionAlgorithm)) {
                ZipOutputStream z = new ZipOutputStream(out);
                z.putNextEntry(new ZipEntry(entryName));
                out = z;
            } else if ("DEFLATE".equals(compressionAlgorithm)) {
                out = new DeflaterOutputStream(out);
            } else if ("LZF".equals(compressionAlgorithm)) {
                out = new LZFOutputStream(out);
            } else if (compressionAlgorithm != null) {
                throw Message.getSQLException(90103, compressionAlgorithm);
            }
            return out;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
    }

    public static InputStream wrapInputStream(InputStream in, String compressionAlgorithm, String entryName) throws SQLException {
        try {
            if ("GZIP".equals(compressionAlgorithm)) {
                in = new GZIPInputStream(in);
            } else if ("ZIP".equals(compressionAlgorithm)) {
                ZipEntry entry;
                ZipInputStream z = new ZipInputStream(in);
                do {
                    if ((entry = z.getNextEntry()) != null) continue;
                    return null;
                } while (!entryName.equals(entry.getName()));
                in = z;
            } else if ("DEFLATE".equals(compressionAlgorithm)) {
                in = new InflaterInputStream(in);
            } else if ("LZF".equals(compressionAlgorithm)) {
                in = new LZFInputStream(in);
            } else if (compressionAlgorithm != null) {
                throw Message.getSQLException(90103, compressionAlgorithm);
            }
            return in;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
    }
}

