/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.server.ftp.FileObject;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;

public class FileObjectNative
implements FileObject {
    private File file;

    static FileObjectNative get(String name) {
        name = FileUtils.translateFileName(name);
        return new FileObjectNative(new File(name));
    }

    private FileObjectNative(File f) {
        this.file = f;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public long length() {
        return this.file.length();
    }

    public FileObject[] listFiles() {
        File[] list = this.file.listFiles();
        FileObject[] result = new FileObject[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = FileObjectNative.get(list[i].getAbsolutePath());
        }
        return result;
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public boolean renameTo(FileObject newFile) {
        return this.file.renameTo(((FileObjectNative)newFile).file);
    }

    public void write(InputStream in) throws IOException {
        try {
            FileOutputStream out = FileUtils.openFileOutputStream(this.file.getAbsolutePath());
            IOUtils.copyAndClose(in, out);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void read(long skip, OutputStream out) throws IOException {
        InputStream in = FileUtils.openFileInputStream(this.file.getAbsolutePath());
        IOUtils.skipFully(in, skip);
        IOUtils.copyAndClose(in, out);
    }
}

