/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Sequence;

public class AlterSequence
extends DefineCommand {
    private Sequence sequence;
    private boolean newStart;
    private long start;
    private boolean newIncrement;
    private long increment;

    public AlterSequence(Session session) {
        super(session);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setStartWith(long start) {
        this.newStart = true;
        this.start = start;
    }

    public void setIncrement(long increment) throws SQLException {
        this.newIncrement = true;
        if (increment == 0L) {
            throw Message.getSQLException(90008, new String[]{"0", "INCREMENT"});
        }
        this.increment = increment;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.newStart) {
            this.sequence.setStartValue(this.start);
        }
        if (this.newIncrement) {
            this.sequence.setIncrement(this.increment);
        }
        db.update(this.session, this.sequence);
        return 0;
    }
}

