/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    AlterTableConstantAction(SchemaDescriptor schemaDescriptor, String string, UUID uUID, long l, int n, ColumnInfo[] columnInfoArray, ConstraintConstantAction[] constraintConstantActionArray, char c, boolean bl, int n2, boolean bl2, boolean bl3) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.tableName = string;
        this.tableConglomerateId = l;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = constraintConstantActionArray;
        this.lockGranularity = c;
        this.compressTable = bl;
        this.behavior = n2;
        this.sequential = bl2;
        this.truncateTable = bl3;
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        String[] stringArray;
        int n;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        int n2 = 0;
        boolean bl = false;
        dataDictionary.startWriting(languageConnectionContext);
        if (this.tableConglomerateId == 0L) {
            this.td = dataDictionary.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(transactionController, this.tableConglomerateId, true);
        this.td = dataDictionary.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            dependencyManager.invalidateFor(this.td, 42, languageConnectionContext);
        } else {
            dependencyManager.invalidateFor(this.td, 12, languageConnectionContext);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(dataDictionary, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            dependencyManager.invalidateFor(this.td, 42, languageConnectionContext);
        } else {
            dependencyManager.invalidateFor(this.td, 12, languageConnectionContext);
        }
        if (this.columnInfo != null) {
            int n3;
            n = 0;
            for (n3 = 0; n3 < this.columnInfo.length; ++n3) {
                if (this.columnInfo[n3].action != 0 || this.columnInfo[n3].dataType.isNullable() || this.columnInfo[n3].defaultInfo != null || this.columnInfo[n3].autoincInc != 0L) continue;
                n = 1;
            }
            if (n != 0) {
                n2 = this.getSemiRowCount(transactionController);
                if (n2 > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                bl = true;
            }
            for (n3 = 0; n3 < this.columnInfo.length; ++n3) {
                ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
                if (this.columnInfo[n3].action == 0) {
                    this.addNewColumnToTable(activation, languageConnectionContext, dataDictionary, transactionController, n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 5 || this.columnInfo[n3].action == 6 || this.columnInfo[n3].action == 7) {
                    this.modifyColumnDefault(activation, n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 2) {
                    this.modifyColumnType(activation, n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 3) {
                    this.modifyColumnConstraint(activation, this.columnInfo[n3].name, true);
                    continue;
                }
                if (this.columnInfo[n3].action == 4) {
                    boolean[] blArray;
                    if (!bl) {
                        bl = true;
                        n2 = this.getSemiRowCount(transactionController);
                    }
                    if (!this.validateNotNullConstraint(stringArray = new String[]{this.columnInfo[n3].name}, blArray = new boolean[1], n2, languageConnectionContext, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(activation, this.columnInfo[n3].name, false);
                    continue;
                }
                if (this.columnInfo[n3].action != 1) continue;
                this.dropColumnFromTable(activation, n3);
            }
        }
        if (this.constraintActions != null) {
            for (n = 0; n < this.constraintActions.length; ++n) {
                ConstraintConstantAction constraintConstantAction = this.constraintActions[n];
                if (constraintConstantAction instanceof CreateConstraintConstantAction) {
                    int n4 = constraintConstantAction.getConstraintType();
                    switch (n4) {
                        case 2: {
                            stringArray = dataDictionary.getConstraintDescriptors(this.td);
                            if (stringArray.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (bl) break;
                            bl = true;
                            n2 = this.getSemiRowCount(transactionController);
                            break;
                        }
                        case 4: {
                            if (!bl) {
                                bl = true;
                                n2 = this.getSemiRowCount(transactionController);
                            }
                            if (n2 <= 0) break;
                            ConstraintConstantAction.validateConstraint(constraintConstantAction.getConstraintName(), ((CreateConstraintConstantAction)constraintConstantAction).getConstraintText(), this.td, languageConnectionContext, true);
                        }
                    }
                }
                this.constraintActions[n].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            this.td.setLockGranularity(this.lockGranularity);
            dataDictionary.updateLockGranularity(this.td, this.sd, this.lockGranularity, transactionController);
        }
        if (this.compressTable) {
            this.compressTable(activation);
        }
        if (this.truncateTable) {
            this.truncateTable(activation);
        }
    }

    private void addNewColumnToTable(Activation activation, LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, TransactionController transactionController, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        int n2 = this.td.getMaxColumnID() + n;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[n].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        DataValueDescriptor dataValueDescriptor = this.columnInfo[n].defaultValue != null ? this.columnInfo[n].defaultValue : this.columnInfo[n].dataType.getNull();
        transactionController.addColumnToConglomerate(this.td.getHeapConglomerateId(), n2, dataValueDescriptor, this.columnInfo[n].dataType.getCollationType());
        UUID uUID = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && uUID == null) {
            uUID = dataDictionary.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2 + 1, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, uUID, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        dataDictionary.addDescriptor(columnDescriptor, this.td, 2, false, transactionController);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            this.updateNewAutoincrementColumn(activation, this.columnInfo[n].name, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(activation, this.columnInfo[n].name, this.columnInfo[n].defaultInfo.getDefaultText(), languageConnectionContext);
        }
        dataDictionary.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), transactionController);
    }

    private void dropColumnFromTable(Activation activation, int n) throws StandardException {
        int n2;
        Object object;
        ConstraintDescriptor constraintDescriptor;
        int n3;
        int n4;
        Serializable serializable;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.columnInfo[n].name, (Object)this.td.getQualifiedName());
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
        int n5 = columnDescriptorList.size();
        if (n5 == 1) {
            throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)("THE *LAST* COLUMN " + this.columnInfo[n].name), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        this.droppedColumnPosition = columnDescriptor.getPosition();
        boolean bl = this.behavior == 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n5 + 1);
        formatableBitSet.set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap(formatableBitSet);
        dependencyManager.invalidateFor(this.td, bl ? 37 : 46, languageConnectionContext);
        if (columnDescriptor.getDefaultInfo() != null) {
            dependencyManager.clearDependencies(languageConnectionContext, columnDescriptor.getDefaultDescriptor(dataDictionary));
        }
        GenericDescriptorList genericDescriptorList = dataDictionary.getTriggerDescriptors(this.td);
        Enumeration enumeration = genericDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            int n6;
            serializable = (TriggerDescriptor)enumeration.nextElement();
            int[] nArray = ((TriggerDescriptor)serializable).getReferencedCols();
            if (nArray == null) continue;
            n4 = nArray.length;
            n3 = 0;
            for (n6 = 0; n6 < n4; ++n6) {
                if (nArray[n6] > this.droppedColumnPosition) {
                    n3 = 1;
                    continue;
                }
                if (nArray[n6] != this.droppedColumnPosition) continue;
                if (bl) {
                    ((TriggerDescriptor)serializable).drop(languageConnectionContext);
                    activation.addWarning(StandardException.newWarning("01502", ((TriggerDescriptor)serializable).getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)this.columnInfo[n].name, (Object)"TRIGGER", (Object)((TriggerDescriptor)serializable).getName());
            }
            if (n6 != n4 || n3 == 0) continue;
            dataDictionary.dropTriggerDescriptor((TriggerDescriptor)serializable, transactionController);
            for (n6 = 0; n6 < n4; ++n6) {
                if (nArray[n6] <= this.droppedColumnPosition) continue;
                int n7 = n6;
                nArray[n7] = nArray[n7] - 1;
            }
            dataDictionary.addDescriptor((TupleDescriptor)((Object)serializable), this.sd, 13, false, transactionController);
        }
        serializable = dataDictionary.getConstraintDescriptors(this.td);
        int n8 = ((ArrayList)serializable).size();
        n4 = 0;
        ConstraintDescriptor[] constraintDescriptorArray = new ConstraintDescriptor[n8];
        for (n3 = n8 - 1; n3 >= 0; --n3) {
            int n9;
            constraintDescriptor = ((ConstraintDescriptorList)serializable).elementAt(n3);
            object = constraintDescriptor.getReferencedColumns();
            n2 = ((int[])object).length;
            boolean bl2 = false;
            for (n9 = 0; n9 < n2; ++n9) {
                if (object[n9] > this.droppedColumnPosition) {
                    bl2 = true;
                }
                if (object[n9] == this.droppedColumnPosition) break;
            }
            if (n9 == n2) {
                if (!(constraintDescriptor instanceof CheckConstraintDescriptor) || !bl2) continue;
                dataDictionary.dropConstraintDescriptor(constraintDescriptor, transactionController);
                for (n9 = 0; n9 < n2; ++n9) {
                    if (object[n9] <= this.droppedColumnPosition) continue;
                    Object object2 = object;
                    int n10 = n9;
                    object2[n10] = object2[n10] - true;
                }
                ((CheckConstraintDescriptor)constraintDescriptor).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl((int[])object));
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                continue;
            }
            if (!bl) {
                throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)this.columnInfo[n].name, (Object)"CONSTRAINT", (Object)constraintDescriptor.getConstraintName());
            }
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                constraintDescriptorArray[n4++] = constraintDescriptor;
                continue;
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            constraintDescriptor.drop(languageConnectionContext, true);
            activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            constraintDescriptor = constraintDescriptorArray[n3];
            constraintDescriptor.drop(languageConnectionContext, false);
            activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
            if (bl) {
                object = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
                for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                    ConstraintDescriptor constraintDescriptor2 = ((ConstraintDescriptorList)object).elementAt(n2);
                    dependencyManager.invalidateFor(constraintDescriptor2, 19, languageConnectionContext);
                    constraintDescriptor2.drop(languageConnectionContext, true);
                    activation.addWarning(StandardException.newWarning("01500", constraintDescriptor2.getConstraintName(), constraintDescriptor2.getTableDescriptor().getName()));
                }
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, constraintDescriptor);
        }
        this.td = dataDictionary.getTableDescriptor(this.tableId);
        this.compressTable(activation);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n5 - columnDescriptor.getPosition()];
        int n11 = columnDescriptor.getPosition();
        int n12 = 0;
        while (n11 < n5) {
            ColumnDescriptor columnDescriptor2 = columnDescriptorList.elementAt(n11);
            dataDictionary.dropColumnDescriptor(this.td.getUUID(), columnDescriptor2.getColumnName(), transactionController);
            columnDescriptor2.setPosition(n11);
            tupleDescriptorArray[n12] = columnDescriptor2;
            ++n11;
            ++n12;
        }
        dataDictionary.addDescriptorArray(tupleDescriptorArray, this.td, 2, false, transactionController);
        List list = dataDictionary.getProvidersDescriptorList(this.td.getObjectID().toString());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)listIterator.next();
            DependableFinder dependableFinder = dependencyDescriptor.getProviderFinder();
            if (!(dependableFinder instanceof DDColumnDependableFinder)) continue;
            DDColumnDependableFinder dDColumnDependableFinder = (DDColumnDependableFinder)dependableFinder;
            FormatableBitSet formatableBitSet2 = new FormatableBitSet(dDColumnDependableFinder.getColumnBitMap());
            FormatableBitSet formatableBitSet3 = new FormatableBitSet(formatableBitSet2);
            formatableBitSet3.clear();
            int n13 = formatableBitSet2.getLength();
            for (int i = 0; i < n13; ++i) {
                if (i < this.droppedColumnPosition && formatableBitSet2.isSet(i)) {
                    formatableBitSet3.set(i);
                }
                if (i <= this.droppedColumnPosition || !formatableBitSet2.isSet(i)) continue;
                formatableBitSet3.set(i - 1);
            }
            if (formatableBitSet3.equals(formatableBitSet2)) continue;
            dataDictionary.dropStoredDependency(dependencyDescriptor, transactionController);
            dDColumnDependableFinder.setColumnBitMap(formatableBitSet3.getByteArray());
            dataDictionary.addDescriptor(dependencyDescriptor, null, 6, true, transactionController);
        }
        dataDictionary.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), transactionController, columnDescriptor);
    }

    private void modifyColumnType(Activation activation, int n) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        ColumnDescriptor columnDescriptor2 = null;
        columnDescriptor2 = new ColumnDescriptor(this.columnInfo[n].name, columnDescriptor.getPosition(), this.columnInfo[n].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        dataDictionary.addDescriptor(columnDescriptor2, this.td, 2, false, transactionController);
    }

    private void modifyColumnConstraint(Activation activation, String string, boolean bl) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        ColumnDescriptor columnDescriptor2 = null;
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType().getNullabilityType(bl);
        columnDescriptor2 = new ColumnDescriptor(string, columnDescriptor.getPosition(), dataTypeDescriptor, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc());
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), string, transactionController);
        dataDictionary.addDescriptor(columnDescriptor2, this.td, 2, false, transactionController);
    }

    private void modifyColumnDefault(Activation activation, int n) throws StandardException {
        Object object;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        int n2 = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            object = new DefaultDescriptor(dataDictionary, this.columnInfo[n].oldDefaultUUID, this.td.getUUID(), n2);
            dependencyManager.invalidateFor((Provider)object, 31, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, (Dependent)object);
        }
        object = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && object == null) {
            object = dataDictionary.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, (UUID)object, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc, this.columnInfo[n].autoinc_create_or_modify_Start_Increment);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        dataDictionary.addDescriptor(columnDescriptor, this.td, 2, false, transactionController);
        if (this.columnInfo[n].action == 6) {
            long l = this.getColumnMax(activation, this.td, this.columnInfo[n].name, this.columnInfo[n].autoincInc, this.columnInfo[n].autoincStart);
            dataDictionary.setAutoincrementValue(transactionController, this.td.getUUID(), this.columnInfo[n].name, l, true);
        } else if (this.columnInfo[n].action == 5) {
            dataDictionary.setAutoincrementValue(transactionController, this.td.getUUID(), this.columnInfo[n].name, this.columnInfo[n].autoincStart, false);
        }
    }

    private void compressTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        ExecRow execRow = this.td.getEmptyExecRow();
        int[] nArray = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes(activation);
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow execRow2 = activation.getExecutionFactory().getValueRow(execRow.nColumns() - 1);
            int[] nArray2 = new int[nArray.length - 1];
            for (int i = 0; i < execRow2.nColumns(); ++i) {
                execRow2.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? execRow.getColumn(i + 1) : execRow.getColumn(i + 1 + 1));
                nArray2[i] = nArray[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            execRow = execRow2;
            nArray = nArray2;
        }
        this.setUpAllSorts(execRow, rowLocation);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long l = this.tc.createAndLoadConglomerate("heap", execRow.getRowArray(), null, nArray, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController scanController = this.tc.openScan(l, false, 4, 7, 5, null, null, 0, null, null, 0);
        scanController.setEstimatedRowCount(this.rowCount);
        scanController.close();
        scanController = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(l, this.dd);
        }
        long l2 = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void truncateTable(Activation activation) throws StandardException {
        Object object;
        TupleDescriptor tupleDescriptor;
        Object object2;
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            object2 = constraintDescriptorList.elementAt(i);
            if (!(object2 instanceof ReferencedKeyConstraintDescriptor) || !((ReferencedKeyConstraintDescriptor)(tupleDescriptor = (ReferencedKeyConstraintDescriptor)object2)).hasNonSelfReferencingFK(1)) continue;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        GenericDescriptorList genericDescriptorList = this.dd.getTriggerDescriptors(this.td);
        object2 = genericDescriptorList.elements();
        while (object2.hasMoreElements()) {
            tupleDescriptor = (TriggerDescriptor)object2.nextElement();
            if (!((TriggerDescriptor)tupleDescriptor).listensForEvent(2) || !((TriggerDescriptor)tupleDescriptor).isEnabled()) continue;
            throw StandardException.newException("XCL49.S", (Object)this.td.getName(), (Object)((TriggerDescriptor)tupleDescriptor).getName());
        }
        ExecRow execRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long l = this.tc.createConglomerate("heap", execRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes(activation);
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            for (int i = 0; i < this.numIndexes; ++i) {
                this.indexRows[i] = this.compressIRGs[i].getIndexRowTemplate();
                this.compressIRGs[i].getIndexRow(execRow, rowLocation, this.indexRows[i], null);
                int[] nArray = this.compressIRGs[i].baseColumnPositions();
                object = this.compressIRGs[i].isAscending();
                int n = nArray.length + 1;
                this.ordering[i] = new ColumnOrdering[n];
                this.collation[i] = new int[nArray.length + 1];
                for (int j = 0; j < n - 1; ++j) {
                    this.ordering[i][j] = new IndexColumnOrder(j, (boolean)object[j]);
                }
                this.ordering[i][n - 1] = new IndexColumnOrder(n - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] lArray = new long[this.numIndexes];
            for (int i = 0; i < this.numIndexes; ++i) {
                this.updateIndex(l, this.dd, i, lArray);
            }
        }
        long l2 = this.td.getHeapConglomerateId();
        object = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor((ConglomerateDescriptor)object, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void updateAllIndexes(long l, DataDictionary dataDictionary) throws StandardException {
        long[] lArray = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(l, dataDictionary, 0, lArray);
            }
            for (int i = 1; i < this.numIndexes; ++i) {
                this.openBulkFetchScan(l);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(i, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(l, dataDictionary, i, lArray);
                this.closeBulkFetchScan();
            }
        } else {
            for (int i = 0; i < this.numIndexes; ++i) {
                this.updateIndex(l, dataDictionary, i, lArray);
            }
        }
    }

    private void updateIndex(long l, DataDictionary dataDictionary, int n, long[] lArray) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[n]);
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.indexConglomerateNumbers[n], false, 4, 7, 5);
        conglomerateController.getInternalTablePropertySet(properties);
        int n2 = this.indexRows[n].nColumns();
        properties.put("baseConglomerateId", Long.toString(l));
        if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(n2 - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(n2));
        }
        properties.put("rowLocationColumn", Integer.toString(n2 - 1));
        properties.put("nKeyFields", Integer.toString(n2));
        conglomerateController.close();
        CardinalityCounter cardinalityCounter = null;
        boolean bl = false;
        if (!this.truncateTable) {
            long l2;
            this.sorters[n].completedInserts();
            this.sorters[n] = null;
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n]));
                bl = true;
            } else {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n]));
            }
            lArray[n] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], this.collation[n], properties, 0, cardinalityCounter, null);
            if (bl) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
            if ((l2 = cardinalityCounter.getRowCount()) > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                for (int i = 0; i < lArray2.length; ++i) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(l2, lArray2[i]), i + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                }
            }
        } else {
            lArray[n] = this.tc.createConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], this.collation[n], properties, 0);
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
        }
        dataDictionary.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[n]), lArray[n], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[n]);
    }

    private void getAffectedIndexes(Activation activation) throws StandardException {
        int n;
        Object[] objectArray;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        if (!this.compressTable && !this.truncateTable) {
            int n2;
            Object[] objectArray2;
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor conglomerateDescriptor;
                objectArray2 = this.compressIRGs[i].baseColumnPositions();
                for (n2 = 0; n2 < objectArray2.length && objectArray2[n2] != this.droppedColumnPosition; ++n2) {
                }
                if (n2 == objectArray2.length) continue;
                if (objectArray2.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    conglomerateDescriptor.drop(activation.getLanguageConnectionContext(), this.td);
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)conglomerateDescriptor.getConglomerateName());
            }
            objectArray = new IndexRowGenerator[this.numIndexes];
            objectArray2 = new long[this.numIndexes];
            n2 = 0;
            n = 0;
            while (n2 < this.numIndexes) {
                while (this.compressIRGs[n] == null) {
                    ++n;
                }
                int[] nArray = this.compressIRGs[n].baseColumnPositions();
                objectArray[n2] = this.compressIRGs[n];
                objectArray2[n2] = (int)this.indexConglomerateNumbers[n];
                boolean[] blArray = this.compressIRGs[n].isAscending();
                boolean bl = false;
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (nArray[i] > this.droppedColumnPosition) {
                        int n4 = i;
                        nArray[n4] = nArray[n4] - 1;
                        continue;
                    }
                    if (nArray[i] != this.droppedColumnPosition) continue;
                    nArray[i] = 0;
                    bl = true;
                }
                if (bl) {
                    int[] nArray2 = new int[--n3];
                    boolean[] blArray2 = new boolean[n3];
                    int n5 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (n5 == 0 && nArray[i + n5] == 0) {
                            ++n5;
                        }
                        nArray2[i] = nArray[i + n5];
                        blArray2[i] = blArray[i + n5];
                    }
                    IndexDescriptor indexDescriptor = this.compressIRGs[n].getIndexDescriptor();
                    indexDescriptor.setBaseColumnPositions(nArray2);
                    indexDescriptor.setIsAscending(blArray2);
                    indexDescriptor.setNumberOfOrderedColumns(indexDescriptor.numberOfOrderedColumns() - 1);
                }
                ++n2;
                ++n;
            }
            this.compressIRGs = objectArray;
            this.indexConglomerateNumbers = objectArray2;
        }
        if ((objectArray = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])objectArray[1];
            this.compressIRGs = (IndexRowGenerator[])objectArray[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int i = 0; i < this.numIndexes; ++i) {
            int[] nArray = this.compressIRGs[i].getIndexDescriptor().baseColumnPositions();
            for (n = 0; n < nArray.length; ++n) {
                this.indexedCols.set(nArray[n]);
            }
        }
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.collation = new int[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        int[] nArray = this.td.getColumnCollationIds();
        for (n = 0; n < this.numIndexes; ++n) {
            this.indexRows[n] = this.compressIRGs[n].getIndexRowTemplate();
            this.compressIRGs[n].getIndexRow(execRow, rowLocation, this.indexRows[n], null);
            this.collation[n] = this.compressIRGs[n].getColumnCollationIds(this.td.getColumnDescriptorList());
            int[] nArray2 = this.compressIRGs[n].baseColumnPositions();
            boolean[] blArray = this.compressIRGs[n].isAscending();
            int n2 = nArray2.length + 1;
            boolean bl = this.numIndexes == 1;
            BasicSortObserver basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n], bl);
            this.ordering[n] = new ColumnOrdering[n2];
            for (int i = 0; i < n2 - 1; ++i) {
                this.ordering[n][i] = new IndexColumnOrder(i, blArray[i]);
            }
            this.ordering[n][n2 - 1] = new IndexColumnOrder(n2 - 1);
            this.sortIds[n] = this.tc.createSort(null, this.indexRows[n].getRowArrayClone(), this.ordering[n], basicSortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (n = 0; n < this.numIndexes; ++n) {
            this.sorters[n] = this.tc.openSort(this.sortIds[n]);
            this.needToDropSort[n] = true;
        }
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        int n;
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int n2;
            n = 0;
            n = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = n != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += n;
            for (n2 = 0; n2 < n; ++n2) {
                this.validRow[n2] = true;
            }
            for (n2 = n; n2 < this.bulkFetchSize; ++n2) {
                this.validRow[n2] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (n = 0; n < this.currentRow.nColumns(); ++n) {
                    this.currentRow.setColumn(n + 1, n < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(n + 1) : this.baseRow[this.currentCompressRow].getColumn(n + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int n = this.compressIRGs.length;
            if (n > 1 && this.sequential) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                this.insertIntoSorter(i, rowLocation);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int n, RowLocation rowLocation) throws StandardException {
        this.indexRows[n].getNewObjectArray();
        this.compressIRGs[n].getIndexRow(this.currentRow, (RowLocation)rowLocation.cloneObject(), this.indexRows[n], null);
        this.sorters[n].insert(this.indexRows[n].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int n;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (n = 0; n < this.compressIRGs.length; ++n) {
                if (this.sorters[n] != null) {
                    this.sorters[n].completedInserts();
                }
                this.sorters[n] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (n = 0; n < this.needToDropSort.length; ++n) {
                if (!this.needToDropSort[n]) continue;
                this.tc.dropSort(this.sortIds[n]);
                this.needToDropSort[n] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController transactionController) throws StandardException {
        int n = 0;
        ScanController scanController = transactionController.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (scanController.next() && ++n != 2) {
        }
        scanController.close();
        return n;
    }

    private void updateNewColumnToDefault(Activation activation, String string, String string2, LanguageConnectionContext languageConnectionContext) throws StandardException {
        String string3 = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + string + "\" = " + string2;
        AlterTableConstantAction.executeUpdate(languageConnectionContext, string3);
    }

    private static void executeUpdate(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string);
        ResultSet resultSet = preparedStatement.execute(languageConnectionContext, true, 0L);
        resultSet.close();
        resultSet.finish();
    }

    private long getColumnMax(Activation activation, TableDescriptor tableDescriptor, String string, long l, long l2) throws StandardException {
        String string2 = l > 0L ? "MAX" : "MIN";
        String string3 = "SELECT " + string2 + "(\"" + string + "\")" + "FROM \"" + tableDescriptor.getSchemaName() + "\".\"" + tableDescriptor.getName() + "\"";
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string3);
        ResultSet resultSet = preparedStatement.execute(languageConnectionContext, false, 0L);
        DataValueDescriptor[] dataValueDescriptorArray = resultSet.getNextRow().getRowArray();
        resultSet.close();
        resultSet.finish();
        return dataValueDescriptorArray[0].getLong();
    }

    private void dropAllColumnDefaults(UUID uUID, DataDictionary dataDictionary) throws StandardException {
        ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            if (columnDescriptor.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
            this.dm.clearDependencies(this.lcc, defaultDescriptor);
        }
    }

    private void openBulkFetchScan(long l) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(l, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(Activation activation, String string, long l, long l2) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        languageConnectionContext.setAutoincrementUpdate(true);
        languageConnectionContext.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), string, new Long(l), l2, 0);
        String string2 = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + string + "\" = " + "org.apache.derby.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + "'" + this.td.getSchemaName() + "'" + "," + "'" + this.td.getName() + "'" + "," + "'" + string + "'" + ")";
        try {
            try {
                AlterTableConstantAction.executeUpdate(languageConnectionContext, string2);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("22003")) {
                    throw StandardException.newException("42Z24", standardException, (Object)this.td.getName(), (Object)string);
                }
                throw standardException;
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            languageConnectionContext.autoincrementFlushCache(this.td.getUUID());
            languageConnectionContext.setAutoincrementUpdate(false);
            throw throwable;
        }
        languageConnectionContext.autoincrementFlushCache(this.td.getUUID());
        languageConnectionContext.setAutoincrementUpdate(false);
    }

    private boolean validateNotNullConstraint(String[] stringArray, boolean[] blArray, int n, LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(stringArray[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)stringArray[i], (Object)this.td.getName());
            }
            if (!columnDescriptor.getType().isNullable()) continue;
            if (n > 0) {
                if (bl) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(stringArray[i] + " IS NOT NULL ");
            }
            bl = true;
            blArray[i] = true;
        }
        if (bl && n > 0 && !ConstraintConstantAction.validateConstraint(null, stringBuffer.toString(), this.td, languageConnectionContext, false)) {
            if (string.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", (Object)this.td.getQualifiedName(), (Object)stringArray[0]);
        }
        return bl;
    }

    private Object[] compressIndexArrays(long[] lArray, IndexRowGenerator[] indexRowGeneratorArray) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length - 1;
        for (int i = 0; i < lArray.length; ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                if (lArray[i] != lArray2[n3]) continue;
                lArray2[n2--] = i;
                break;
            }
            if (n3 != n) continue;
            lArray2[n++] = lArray[i];
        }
        if (n < lArray.length) {
            long[] lArray3 = new long[n];
            IndexRowGenerator[] indexRowGeneratorArray2 = new IndexRowGenerator[n];
            int[] nArray = new int[lArray.length - n];
            n2 = 0;
            int n4 = lArray.length - 1;
            for (int i = 0; i < lArray.length; ++i) {
                if (i < n) {
                    lArray3[i] = lArray2[i];
                } else {
                    nArray[lArray.length - i - 1] = (int)lArray2[i];
                }
                if (n4 >= n && i == (int)lArray2[n4]) {
                    --n4;
                    continue;
                }
                indexRowGeneratorArray2[n2] = indexRowGeneratorArray[i];
                ++n2;
            }
            Object[] objectArray = new Object[]{nArray, lArray3, indexRowGeneratorArray2};
            return objectArray;
        }
        return null;
    }
}

