/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class Script {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <filename>] [-options <option> ...]");
    }

    public static void main(String[] args) throws SQLException {
        new Script().run(args);
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String file = "backup.sql";
        String options1 = null;
        String options2 = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                file = args[++i];
                continue;
            }
            if (args[i].equals("-options")) {
                StringBuffer buff1 = new StringBuffer();
                StringBuffer buff2 = new StringBuffer();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if (upper.startsWith("NO") || "DROP".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || file == null) {
            this.showUsage();
            return;
        }
        if (options1 != null) {
            Script.executeScript(url, user, password, file, options1, options2);
        } else {
            Script.execute(url, user, password, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeScript(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            stat.execute(sql);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    public static void execute(String url, String user, String password, String fileName) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        FileWriter fileWriter = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            fileWriter = FileUtils.openFileWriter(fileName, false);
            PrintWriter writer = new PrintWriter(new BufferedWriter(fileWriter));
            ResultSet rs = stat.executeQuery("SCRIPT");
            while (rs.next()) {
                String s = rs.getString(1);
                writer.println(s + ";");
            }
            writer.close();
        }
        catch (IOException e) {
            try {
                throw Message.convertIOException(e, fileName);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                JdbcUtils.closeSilently(conn);
                IOUtils.closeSilently(fileWriter);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
        IOUtils.closeSilently(fileWriter);
    }
}

