/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BinaryExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.PositionRange;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

class BooleanExpression
extends BinaryExpression {
    public BooleanExpression() {
    }

    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression simplify() throws XPathException {
        this.p1 = this.p1.simplify();
        this.p2 = this.p2.simplify();
        if (this.p1 instanceof Value && this.p2 instanceof Value) {
            return this.evaluate(null);
        }
        if (this.p1 instanceof PositionRange && this.p2 instanceof PositionRange) {
            PositionRange positionRange = (PositionRange)this.p1;
            PositionRange positionRange2 = (PositionRange)this.p2;
            if (positionRange.getMaxPosition() == Integer.MAX_VALUE && positionRange2.getMinPosition() == 1) {
                return new PositionRange(positionRange.getMinPosition(), positionRange2.getMaxPosition());
            }
            if (positionRange2.getMaxPosition() == Integer.MAX_VALUE && positionRange.getMinPosition() == 1) {
                return new PositionRange(positionRange2.getMinPosition(), positionRange.getMaxPosition());
            }
        }
        return this;
    }

    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        switch (this.operator) {
            case 19: {
                return this.p1.evaluateAsBoolean(context) && this.p2.evaluateAsBoolean(context);
            }
            case 18: {
                return this.p1.evaluateAsBoolean(context) || this.p2.evaluateAsBoolean(context);
            }
        }
        throw new XPathException("Unknown operator in boolean expression");
    }

    public int getDataType() {
        return 1;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.getDependencies() & n) != 0) {
            BooleanExpression booleanExpression = new BooleanExpression(this.p1.reduce(n, context), this.operator, this.p2.reduce(n, context));
            booleanExpression.setStaticContext(this.getStaticContext());
            return ((Expression)booleanExpression).simplify();
        }
        return this;
    }
}

