/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junit.framework.AssertionFailedError;

public class ComparisonFailure
extends AssertionFailedError {
    private static final int MINIMAL_LENGTH = 10;
    private String expected;
    private String actual;
    private String message = "";

    public ComparisonFailure(String message, String expected, String actual) {
        super(message);
        this.expected = expected;
        this.actual = actual;
        this.message = ComparisonFailure.createMessage(super.getMessage(), this.expected, this.actual);
    }

    public String getMessage() {
        return this.message;
    }

    protected static String createMessage(String message, String expected, String actual) {
        if (expected == null || actual == null || actual.equals(expected)) {
            return ComparisonFailure.format(message, expected, actual, null);
        }
        int end = Math.min(expected.length(), actual.length());
        int beginDiff = 0;
        while (beginDiff < end && expected.charAt(beginDiff) == actual.charAt(beginDiff)) {
            ++beginDiff;
        }
        int endDiffExp = expected.length() - 1;
        int endDiffAct = actual.length() - 1;
        while (endDiffExp >= beginDiff && endDiffAct >= beginDiff && expected.charAt(endDiffExp) == actual.charAt(endDiffAct)) {
            --endDiffAct;
            --endDiffExp;
        }
        String delta = actual.substring(beginDiff, endDiffAct + 1);
        if (delta.equals("")) {
            delta = expected.substring(beginDiff, endDiffExp + 1);
        }
        boolean optimized = false;
        while (!optimized) {
            if (endDiffAct - beginDiff < 9) {
                if (beginDiff > 0 && !ComparisonFailure.isStopper(actual.charAt(beginDiff))) {
                    --beginDiff;
                    continue;
                }
                if (endDiffAct < actual.length() - 1 && !ComparisonFailure.isStopper(actual.charAt(endDiffAct))) {
                    ++endDiffAct;
                    ++endDiffExp;
                    continue;
                }
                optimized = true;
                continue;
            }
            optimized = true;
        }
        String expectedDisplay = expected.substring(beginDiff, endDiffExp + 1);
        String actualDisplay = actual.substring(beginDiff, endDiffAct + 1);
        if (delta.equals(actualDisplay)) {
            delta = null;
        }
        if (beginDiff > 0) {
            expectedDisplay = "..." + expectedDisplay;
            actualDisplay = "..." + actualDisplay;
        }
        if (endDiffExp < expected.length() - 1) {
            expectedDisplay = expectedDisplay + "...";
        }
        if (endDiffAct < actual.length() - 1) {
            actualDisplay = actualDisplay + "...";
        }
        return ComparisonFailure.format(message, expectedDisplay, actualDisplay, delta);
    }

    private static boolean isStopper(char input) {
        return input == ' ' || input == ',' || input == ';' || input == '(' || input == ')' || input == '[' || input == ']' || input == '{' || input == '}';
    }

    private static String format(String message, String expected, String actual, String delta) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        if (delta == null) {
            return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + "> ['" + delta + "']";
    }
}

