/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RAFContainer;

class RAFContainer4
extends RAFContainer {
    private FileChannel ourChannel = null;
    private int iosInProgress = 0;

    public RAFContainer4(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        boolean bl = super.openContainer(containerKey);
        if (bl && this.fileData != null && this.fileData instanceof RandomAccessFile) {
            this.ourChannel = ((RandomAccessFile)((Object)this.fileData)).getChannel();
        }
        return bl;
    }

    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        super.createContainer(containerKey);
        if (this.fileData != null && this.fileData instanceof RandomAccessFile) {
            this.ourChannel = ((RandomAccessFile)((Object)this.fileData)).getChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeContainer() {
        if (this.ourChannel != null) {
            try {
                this.ourChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ourChannel = null;
            }
        }
        super.closeContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            fileChannel = this.ourChannel;
        }
        if (fileChannel != null) {
            long l2 = l * (long)this.pageSize;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.readFull(byteBuffer, fileChannel, l2);
            if (this.dataFactory.databaseEncrypted() && l != 0L) {
                this.decryptPage(byArray, this.pageSize);
            }
        } else {
            super.readPage(l, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (this.getCommittedDropState()) {
                return;
            }
            fileChannel = this.ourChannel;
        }
        if (fileChannel != null) {
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted()) {
                byArray2 = new byte[this.pageSize];
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            this.dataFactory.writeInProgress();
            try {
                this.writeFull(byteBuffer, fileChannel, l2);
            }
            catch (ClosedChannelException closedChannelException) {
                RAFContainer4 rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    block25: {
                        if (!this.getCommittedDropState()) break block25;
                        return;
                    }
                    throw closedChannelException;
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    fileChannel.force(false);
                    return;
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                RAFContainer4 rAFContainer43 = this;
                synchronized (rAFContainer43) {
                    this.needsSync = true;
                    return;
                }
            }
        }
        super.writePage(l, byArray, bl);
    }

    private final void readFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException {
        while (byteBuffer.remaining() > 0) {
            if (fileChannel.read(byteBuffer, l + (long)byteBuffer.position()) != -1) continue;
            throw new EOFException("Reached end of file while attempting to read a whole page.");
        }
    }

    private final void writeFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException {
        while (byteBuffer.remaining() > 0) {
            fileChannel.write(byteBuffer, l + (long)byteBuffer.position());
        }
    }
}

