/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class JavaAggregate
extends Expression {
    private final UserAggregate userAggregate;
    private final Select select;
    private AggregateFunction aggregate;
    private Expression[] args;
    private int[] argTypes;
    private int dataType;
    private Connection userConnection;

    public JavaAggregate(UserAggregate userAggregate, Expression[] args, Select select) throws SQLException {
        this.userAggregate = userAggregate;
        this.args = args;
        this.select = select;
    }

    public int getCost() {
        int cost = 5;
        for (int i = 0; i < this.args.length; ++i) {
            cost += this.args[i].getCost();
        }
        return cost;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append(Parser.quoteIdentifier(this.userAggregate.getName()));
        buff.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Expression e = this.args[i];
            buff.append(e.getSQL());
        }
        buff.append(')');
        return buff.toString();
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return this.dataType;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.type == 2) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(resolver, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        this.userConnection = session.createConnection(false);
        this.argTypes = new int[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            Expression expr = this.args[i];
            this.args[i] = expr.optimize(session);
            this.argTypes[i] = expr.getType();
        }
        this.aggregate = this.getInstance();
        this.dataType = this.aggregate.getType(this.argTypes);
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].setEvaluatable(tableFilter, b);
        }
    }

    private AggregateFunction getInstance() throws SQLException {
        AggregateFunction agg = this.userAggregate.getInstance();
        agg.init(this.userConnection);
        return agg;
    }

    public Value getValue(Session session) throws SQLException {
        Object obj;
        HashMap group = this.select.getCurrentGroup();
        if (group == null) {
            throw Message.getSQLException(90054, this.getSQL());
        }
        AggregateFunction agg = (AggregateFunction)group.get(this);
        if (agg == null) {
            agg = this.getInstance();
        }
        if ((obj = agg.getResult()) == null) {
            return ValueNull.INSTANCE;
        }
        return DataType.convertToValue(session, obj, this.dataType);
    }

    public void updateAggregate(Session session) throws SQLException {
        HashMap group = this.select.getCurrentGroup();
        if (group == null) {
            return;
        }
        AggregateFunction agg = (AggregateFunction)group.get(this);
        if (agg == null) {
            agg = this.getInstance();
            group.put(this, agg);
        }
        Object[] argValues = new Object[this.args.length];
        Object arg = null;
        for (int i = 0; i < this.args.length; ++i) {
            Value v = this.args[i].getValue(session);
            v = v.convertTo(this.argTypes[i]);
            argValues[i] = arg = v.getObject();
        }
        if (this.args.length == 1) {
            agg.add(arg);
        } else {
            agg.add(argValues);
        }
    }
}

