/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class GroupMarkerSubRecord
extends SubRecord {
    public static final short sid = 6;
    private byte[] reserved = new byte[0];

    public GroupMarkerSubRecord() {
    }

    public GroupMarkerSubRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 6) {
            throw new RecordFormatException("Not a Group Marker record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.reserved = in.readRemainder();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append("[ftGmo]" + nl);
        buffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(nl);
        buffer.append("[/ftGmo]" + nl);
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)6);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        System.arraycopy(this.reserved, 0, data, offset + 4, this.getRecordSize() - 4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.reserved.length;
    }

    public short getSid() {
        return 6;
    }

    public Object clone() {
        GroupMarkerSubRecord rec = new GroupMarkerSubRecord();
        rec.reserved = new byte[this.reserved.length];
        for (int i = 0; i < this.reserved.length; ++i) {
            rec.reserved[i] = this.reserved[i];
        }
        return rec;
    }
}

