/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.pdf.PDFStream;

public class PDFICCStream
extends PDFStream {
    private int origLength;
    private int len1;
    private int len3;
    private byte[] originalData = null;
    private ColorSpace cs;

    public PDFICCStream(int num) {
        super(num);
        this.cs = null;
    }

    public PDFICCStream(int num, ColorSpace cs) throws IOException {
        super(num);
        this.setColorSpace(cs);
    }

    protected int output(OutputStream stream) throws IOException {
        byte[] p;
        int length = 0;
        String filterEntry = this.applyFilters();
        StringBuffer pb = new StringBuffer();
        pb.append(this.number).append(" ").append(this.generation).append(" obj\n<< ");
        pb.append("/N ").append(this.cs.getNumComponents()).append(" ");
        if (this.cs.getColorSpace() > 0) {
            pb.append("/Alternate /").append(this.cs.getColorSpacePDFString()).append(" ");
        }
        pb.append("/Length ").append(this._data.size() + 1).append(" ").append(filterEntry);
        pb.append(" >>\n");
        try {
            p = pb.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            p = pb.toString().getBytes();
        }
        stream.write(p);
        length += p.length;
        length += this.outputStreamData(stream);
        try {
            p = "endobj\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            p = "endobj\n".getBytes();
        }
        stream.write(p);
        return length += p.length;
    }

    public void setColorSpace(ColorSpace cs) throws IOException {
        this.cs = cs;
        this.setData(cs.getICCProfile());
    }
}

