/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class Any2sRGBRed
extends AbstractRed {
    boolean srcIsLsRGB = false;
    private static final double GAMMA = 2.4;
    private static final int[] linearToSRGBLut = new int[256];

    public Any2sRGBRed(CachableRed cachableRed) {
        super(cachableRed, cachableRed.getBounds(), Any2sRGBRed.fixColorModel(cachableRed), Any2sRGBRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel == null) {
            return;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            this.srcIsLsRGB = true;
        }
    }

    public static boolean is_INT_PACK_COMP(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != 3 && nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static WritableRaster applyLut_INT(WritableRaster writableRaster, int[] nArray) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray2 = dataBufferInt.getBankData()[0];
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = singlePixelPackedSampleModel.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n + i * n4; n5 < n6; ++n5) {
                int n7 = nArray2[n5];
                nArray2[n5] = n7 & 0xFF000000 | nArray[n7 >>> 16 & 0xFF] << 16 | nArray[n7 >>> 8 & 0xFF] << 8 | nArray[n7 & 0xFF];
            }
        }
        return writableRaster;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (this.srcIsLsRGB && Any2sRGBRed.is_INT_PACK_COMP(writableRaster.getSampleModel())) {
            cachableRed.copyData(writableRaster);
            if (colorModel.hasAlpha()) {
                GraphicsUtil.coerceData(writableRaster, colorModel, false);
            }
            Any2sRGBRed.applyLut_INT(writableRaster, linearToSRGBLut);
            return writableRaster;
        }
        if (colorModel == null) {
            float[][] fArray = null;
            switch (sampleModel.getNumBands()) {
                case 1: {
                    fArray = new float[1][3];
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = 1.0f;
                    fArray[0][2] = 1.0f;
                    break;
                }
                case 2: {
                    fArray = new float[2][4];
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = 1.0f;
                    fArray[0][2] = 1.0f;
                    fArray[1][3] = 1.0f;
                    break;
                }
                case 3: {
                    fArray = new float[3][3];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    break;
                }
                default: {
                    fArray = new float[sampleModel.getNumBands()][4];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    fArray[3][3] = 1.0f;
                }
            }
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
            bandCombineOp.filter(raster, writableRaster);
        } else {
            ColorModel colorModel2 = this.getColorModel();
            if (colorModel.getColorSpace() == colorModel2.getColorSpace()) {
                if (Any2sRGBRed.is_INT_PACK_COMP(sampleModel)) {
                    cachableRed.copyData(writableRaster);
                } else {
                    GraphicsUtil.copyData(cachableRed.getData(writableRaster.getBounds()), writableRaster);
                }
                return writableRaster;
            }
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            WritableRaster writableRaster2 = (WritableRaster)raster;
            ColorModel colorModel3 = colorModel;
            if (colorModel.hasAlpha()) {
                colorModel3 = GraphicsUtil.coerceData(writableRaster2, colorModel, false);
            }
            BufferedImage bufferedImage = new BufferedImage(colorModel3, writableRaster2.createWritableTranslatedChild(0, 0), false, null);
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorModel2.getColorSpace(), null);
            BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
            WritableRaster writableRaster3 = writableRaster.createWritableTranslatedChild(0, 0);
            for (int i = 0; i < colorModel2.getColorSpace().getNumComponents(); ++i) {
                Any2sRGBRed.copyBand(bufferedImage2.getRaster(), i, writableRaster3, i);
            }
            if (colorModel2.hasAlpha()) {
                Any2sRGBRed.copyBand(writableRaster2, sampleModel.getNumBands() - 1, writableRaster, this.getSampleModel().getNumBands() - 1);
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return GraphicsUtil.sRGB_Unpre;
            }
            return GraphicsUtil.sRGB;
        }
        SampleModel sampleModel = cachableRed.getSampleModel();
        switch (sampleModel.getNumBands()) {
            case 1: {
                return GraphicsUtil.sRGB;
            }
            case 2: {
                return GraphicsUtil.sRGB_Unpre;
            }
            case 3: {
                return GraphicsUtil.sRGB;
            }
        }
        return GraphicsUtil.sRGB_Unpre;
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        ColorModel colorModel = cachableRed.getColorModel();
        boolean bl = false;
        if (colorModel != null) {
            bl = colorModel.hasAlpha();
        } else {
            switch (sampleModel.getNumBands()) {
                case 1: 
                case 3: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            return new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216});
        }
        return new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255});
    }

    static {
        for (int i = 0; i < 256; ++i) {
            double d = (double)i * 0.00392156862745098;
            d = d <= 0.0031308 ? (d *= 12.92) : 1.055 * Math.pow(d, 0.4166666666666667) - 0.055;
            Any2sRGBRed.linearToSRGBLut[i] = (int)Math.round(d * 255.0);
        }
    }
}

