/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private Vector transportListeners = new Vector();

    public static void send(Message message) throws MessagingException {
        Transport.send(message, message.getAllRecipients());
    }

    public static void send(Message message, Address[] addresses) throws MessagingException {
        List addrs;
        Transport transport;
        Session session = message.session;
        HashMap msgsByTransport = new HashMap();
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            transport = session.getTransport(address);
            addrs = (ArrayList<Address>)msgsByTransport.get(transport);
            if (addrs == null) {
                addrs = new ArrayList<Address>();
                msgsByTransport.put(transport, addrs);
            }
            addrs.add(address);
        }
        message.saveChanges();
        Iterator i = msgsByTransport.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            transport = (Transport)entry.getKey();
            addrs = (List)entry.getValue();
            transport.sendMessage(message, addrs.toArray(new Address[addrs.size()]));
        }
    }

    public Transport(Session session, URLName name) {
        super(session, name);
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public void addTransportListener(TransportListener listener) {
        this.transportListeners.add(listener);
    }

    public void removeTransportListener(TransportListener listener) {
        this.transportListeners.remove(listener);
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message message) {
        this.queueEvent(new TransportEvent(this, type, validSent, validUnsent, invalid, message), this.transportListeners);
    }
}

