/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.arg;

import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentTypeRegistry;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentsBuilder {
    protected static Logger logger = Logger.getLogger(ArgumentsBuilder.class);
    protected Object bean;
    protected BeanDesc beanDesc;

    public ArgumentsBuilder(Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.bean = bean;
        this.beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
    }

    public List<String> build() {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < this.beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = this.beanDesc.getPropertyDesc(i);
            if (!propertyDesc.hasReadMethod()) continue;
            ArgumentType<Object> argumentType = ArgumentTypeRegistry.getArgumentType(propertyDesc);
            if (argumentType == null) {
                String message = String.format("No ArgumentType for the property(%s) of class(%s). Process skipped.", propertyDesc.getPropertyName(), this.bean.getClass().getName());
                logger.warn((Object)message);
                continue;
            }
            String name = propertyDesc.getPropertyName();
            Object value = propertyDesc.getValue(this.bean);
            args.add(name + "=" + argumentType.toText(value));
        }
        return args;
    }
}

