/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCharsetConvertor {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private CharsetDecoder myDecoder;
    private CharsetEncoder myEncoder;
    private CharBuffer myCharBuffer;
    private ByteBuffer myInputByteBuffer;

    public SVNCharsetConvertor(CharsetDecoder decoder, CharsetEncoder encoder) {
        this.myDecoder = decoder;
        this.myEncoder = encoder;
        this.reset();
    }

    public SVNCharsetConvertor reset() {
        this.myEncoder = this.myEncoder.reset();
        this.myDecoder = this.myDecoder.reset();
        this.myCharBuffer = null;
        this.myInputByteBuffer = null;
        return this;
    }

    public ByteBuffer convertChunk(byte[] b, int offset, int length, ByteBuffer dst, boolean endOfInput) throws SVNException {
        this.myInputByteBuffer = SVNCharsetConvertor.allocate(this.myInputByteBuffer, length);
        this.myInputByteBuffer.put(b, offset, length);
        this.myInputByteBuffer.flip();
        this.myCharBuffer = SVNCharsetConvertor.allocate(this.myCharBuffer, (int)(this.myDecoder.maxCharsPerByte() * (float)this.myInputByteBuffer.remaining()));
        CoderResult result = this.myDecoder.decode(this.myInputByteBuffer, this.myCharBuffer, endOfInput);
        if (result.isError()) {
            SVNCharsetConvertor.throwException(result);
        } else if (result.isUnderflow()) {
            this.myInputByteBuffer.compact();
        } else {
            this.myInputByteBuffer.clear();
        }
        this.myCharBuffer.flip();
        dst = SVNCharsetConvertor.allocate(dst, (int)(this.myEncoder.maxBytesPerChar() * (float)this.myCharBuffer.remaining()));
        result = this.myEncoder.encode(this.myCharBuffer, dst, false);
        if (result.isError()) {
            SVNCharsetConvertor.throwException(result);
        } else if (result.isUnderflow()) {
            this.myCharBuffer.compact();
        } else {
            this.myCharBuffer.clear();
        }
        return dst;
    }

    public ByteBuffer flush(ByteBuffer dst) throws SVNException {
        if (this.myCharBuffer != null) {
            CoderResult result;
            do {
                if (!(result = this.myDecoder.flush(this.myCharBuffer)).isError()) continue;
                SVNCharsetConvertor.throwException(result);
            } while (!result.isUnderflow());
            this.myCharBuffer.flip();
            dst = SVNCharsetConvertor.allocate(dst, (int)(this.myEncoder.maxBytesPerChar() * (float)this.myCharBuffer.remaining()));
            result = this.myEncoder.encode(this.myCharBuffer, dst, true);
            if (result.isError()) {
                SVNCharsetConvertor.throwException(result);
            }
            do {
                if (!(result = this.myEncoder.flush(dst)).isError()) continue;
                SVNCharsetConvertor.throwException(result);
            } while (!result.isUnderflow());
        }
        this.reset();
        return dst;
    }

    private static ByteBuffer allocate(ByteBuffer buffer, int length) {
        if (buffer == null) {
            length = Math.max(length * 3 / 2, 1024);
            return ByteBuffer.allocate(length);
        }
        if (buffer.remaining() < length) {
            ByteBuffer expandedBuffer = ByteBuffer.allocate((buffer.position() + length) * 3 / 2);
            buffer.flip();
            expandedBuffer.put(buffer);
            return expandedBuffer;
        }
        return buffer;
    }

    private static CharBuffer allocate(CharBuffer buffer, int length) {
        if (buffer == null) {
            length = Math.max(length * 3 / 2, 1024);
            return CharBuffer.allocate(length);
        }
        if (buffer.remaining() < length) {
            CharBuffer expandedBuffer = CharBuffer.allocate((buffer.position() + length) * 3 / 2);
            buffer.flip();
            expandedBuffer.put(buffer);
            return expandedBuffer;
        }
        return buffer;
    }

    private static void throwException(CoderResult result) throws SVNException {
        try {
            result.throwException();
        }
        catch (CharacterCodingException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), e, SVNLogType.DEFAULT);
        }
    }
}

