/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;

public class H2GenDialect
extends StandardGenDialect {
    protected static int TABLE_NOT_FOUND_ERROR_CODE = 42102;
    protected static int COLUMN_NOT_FOUND_ERROR_CODE = 42122;
    protected static int SEQUENCE_NOT_FOUND_ERROR_CODE = 90036;

    public H2GenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("binary($l)"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.columnTypeMap.put("binary", H2ColumnType.BINARY);
        this.columnTypeMap.put("decimal", H2ColumnType.DECIMAL);
        this.columnTypeMap.put("uuid", H2ColumnType.UUID);
        this.columnTypeMap.put("varchar_ignorecase", H2ColumnType.VARCHAR_IGNORECASE);
    }

    public String getName() {
        return "h2";
    }

    public String getDefaultSchemaName(String userName) {
        return null;
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsSequence() {
        return true;
    }

    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        return "start with " + initialValue + " increment by " + allocationSize;
    }

    public String getIdentityColumnDefinition() {
        return "generated by default as identity";
    }

    public boolean isTableNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == TABLE_NOT_FOUND_ERROR_CODE;
    }

    public boolean isColumnNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == COLUMN_NOT_FOUND_ERROR_CODE;
    }

    public boolean isSequenceNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == SEQUENCE_NOT_FOUND_ERROR_CODE;
    }

    public boolean supportsIdentityInsert() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "call next value for " + sequenceName;
    }

    public boolean supportsCommentInCreateTable() {
        return false;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class H2ColumnType
    extends StandardGenDialect.StandardColumnType {
        private static H2ColumnType BINARY = new H2ColumnType("binary($l)", byte[].class);
        private static H2ColumnType DECIMAL = new H2ColumnType("decimal($p,$s)", BigDecimal.class);
        private static H2ColumnType UUID = new H2ColumnType("uuid", byte[].class);
        private static H2ColumnType VARCHAR_IGNORECASE = new H2ColumnType("varchar_ignorecase", String.class);

        public H2ColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public H2ColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

