/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.event.GenDdlEvent;
import org.seasar.extension.jdbc.gen.event.GenDdlListener;
import org.seasar.extension.jdbc.gen.internal.exception.NextVersionDirectoryExistsRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.DefaultExcludesFilenameFilter;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.internal.version.wrapper.DdlVersionDirectoryWrapper;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.extension.jdbc.gen.version.DdlVersionIncrementer;
import org.seasar.extension.jdbc.gen.version.ManagedFile;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DdlVersionIncrementerImpl
implements DdlVersionIncrementer {
    protected static Logger logger = Logger.getLogger(DdlVersionIncrementerImpl.class);
    protected DdlVersionDirectoryTree ddlVersionDirectoryTree;
    protected GenDdlListener genDdlListener;
    protected GenDialect dialect;
    protected DataSource dataSource;
    protected List<String> createDirNameList = new ArrayList<String>();
    protected List<String> dropDirNameList = new ArrayList<String>();
    protected List<DdlVersionDirectory> recoveryDirList = new ArrayList<DdlVersionDirectory>();

    public DdlVersionIncrementerImpl(DdlVersionDirectoryTree ddlVersionDirectoryTree, GenDdlListener genDdlListener, GenDialect dialect, DataSource dataSource, List<String> createDirNameList, List<String> dropDirNameList) {
        if (ddlVersionDirectoryTree == null) {
            throw new NullPointerException("ddlVersionDirectoryTree");
        }
        if (genDdlListener == null) {
            throw new NullPointerException("genDdlListener");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (createDirNameList == null) {
            throw new NullPointerException("createDirNameList");
        }
        if (dropDirNameList == null) {
            throw new NullPointerException("dropDirNameList");
        }
        this.ddlVersionDirectoryTree = ddlVersionDirectoryTree;
        this.genDdlListener = genDdlListener;
        this.dialect = dialect;
        this.dataSource = dataSource;
        this.createDirNameList.addAll(createDirNameList);
        this.dropDirNameList.addAll(dropDirNameList);
    }

    @Override
    public void increment(String comment, DdlVersionIncrementer.Callback callback) {
        try {
            DdlVersionDirectory currentVersionDir = this.getCurrentDdlVersionDirectory();
            DdlVersionDirectory nextVersionDir = this.getNextDdlVersionDirectory(currentVersionDir);
            this.copyDirectory(currentVersionDir, nextVersionDir);
            callback.execute(nextVersionDir);
            if (currentVersionDir.isFirstVersion()) {
                this.copyDropDirectory(nextVersionDir, currentVersionDir);
            }
            this.incrementVersionNo(comment);
        }
        catch (RuntimeException e) {
            this.recover();
            throw e;
        }
    }

    protected DdlVersionDirectory getCurrentDdlVersionDirectory() {
        DdlVersionDirectory currentVersionDir = this.ddlVersionDirectoryTree.getCurrentVersionDirectory();
        this.makeDirectory(currentVersionDir);
        return currentVersionDir;
    }

    protected DdlVersionDirectory getNextDdlVersionDirectory(DdlVersionDirectory currentVersionDir) {
        DdlVersionDirectory nextVersionDir = this.ddlVersionDirectoryTree.getNextVersionDirectory();
        if (nextVersionDir.exists()) {
            throw new NextVersionDirectoryExistsRuntimeException(nextVersionDir.asFile().getPath());
        }
        DdlVersionDirectoryWrapper wrapper = new DdlVersionDirectoryWrapper(nextVersionDir, this.genDdlListener, currentVersionDir, nextVersionDir){

            public boolean mkdir() {
                if (this.getManagedFile().exists()) {
                    return false;
                }
                GenDdlEvent event = new GenDdlEvent(this, this.currentVersionDir, this.nextVersionDir);
                this.genDdlListener.preCreateNextVersionDir(event);
                boolean made = this.getManagedFile().mkdir();
                if (made) {
                    this.genDdlListener.postCreateNextVersionDir(event);
                }
                return made;
            }

            public boolean delete() {
                if (!this.getManagedFile().exists()) {
                    return false;
                }
                GenDdlEvent event = new GenDdlEvent(this, this.currentVersionDir, this.nextVersionDir);
                this.genDdlListener.preRemoveNextVersionDir(event);
                boolean deleted = super.delete();
                if (deleted) {
                    this.genDdlListener.postRemoveNextVersionDir(event);
                }
                return deleted;
            }
        };
        this.makeDirectory(wrapper);
        return wrapper;
    }

    protected void makeDirectory(DdlVersionDirectory versionDir) {
        if (versionDir.mkdirs()) {
            this.recoveryDirList.add(versionDir);
        }
    }

    protected void copyDirectory(DdlVersionDirectory src, DdlVersionDirectory dest) {
        ManagedFile srcCreateDir = src.getCreateDirectory();
        ManagedFile destCreateDir = dest.getCreateDirectory();
        this.copyDir(srcCreateDir, destCreateDir, new PathFilenameFilter(srcCreateDir.asFile(), this.createDirNameList));
        ManagedFile srcDropDir = src.getDropDirectory();
        ManagedFile destDropDir = dest.getDropDirectory();
        this.copyDir(srcDropDir, destDropDir, new PathFilenameFilter(srcDropDir.asFile(), this.dropDirNameList));
    }

    protected void copyDropDirectory(DdlVersionDirectory src, DdlVersionDirectory dest) {
        ManagedFile srcDropDir = src.getDropDirectory();
        ManagedFile destDropDir = dest.getDropDirectory();
        this.copyDir(srcDropDir, destDropDir, new DefaultExcludesFilenameFilter());
    }

    protected void copyDir(ManagedFile srcDir, ManagedFile destDir, FilenameFilter filter) {
        destDir.mkdirs();
        for (ManagedFile src : srcDir.listManagedFiles(filter)) {
            ManagedFile dest = destDir.createChild(src.getName());
            if (src.isDirectory()) {
                this.copyDir(src, dest, filter);
                continue;
            }
            dest.createNewFile();
            FileUtil.copy(src.asFile(), dest.asFile());
        }
    }

    protected void recover() {
        for (DdlVersionDirectory dir : this.recoveryDirList) {
            if (!dir.exists()) {
                return;
            }
            try {
                this.deleteDir(dir);
            }
            catch (Exception e) {
                logger.log((Throwable)e);
            }
        }
    }

    protected void deleteDir(ManagedFile dir) {
        for (ManagedFile file : dir.listManagedFiles()) {
            if (file.isDirectory()) {
                this.deleteDir(file);
                file.delete();
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected void incrementVersionNo(String comment) {
        this.ddlVersionDirectoryTree.getDdlInfoFile().applyNextVersionNo(comment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PathFilenameFilter
    implements FilenameFilter {
        protected List<String> excludePathList = new ArrayList<String>();
        protected FilenameFilter filenameFilter = new DefaultExcludesFilenameFilter();

        protected PathFilenameFilter(File baseDir, List<String> excludeDirNameList) {
            this.setupFilterPathList(baseDir, excludeDirNameList);
        }

        protected void setupFilterPathList(File dir, List<String> dirNameList) {
            for (String name : dirNameList) {
                File file = new File(dir, name);
                this.excludePathList.add(FileUtil.getCanonicalPath(file));
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!this.filenameFilter.accept(dir, name)) {
                return false;
            }
            for (String path : this.excludePathList) {
                File file = new File(dir, name);
                if (!FileUtil.getCanonicalPath(file).startsWith(path)) continue;
                return false;
            }
            return true;
        }
    }
}

