/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import javax.persistence.UniqueConstraint;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;

public class UniqueKeyDescFactoryImpl
implements UniqueKeyDescFactory {
    protected GenDialect dialect;

    public UniqueKeyDescFactoryImpl(GenDialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    public UniqueKeyDesc getCompositeUniqueKeyDesc(UniqueConstraint uniqueConstraint) {
        UniqueKeyDesc uniqueKeyDesc = new UniqueKeyDesc();
        for (String columnName : uniqueConstraint.columnNames()) {
            uniqueKeyDesc.addColumnName(columnName);
        }
        if (uniqueKeyDesc.getColumnNameList().isEmpty()) {
            return null;
        }
        return uniqueKeyDesc;
    }

    public UniqueKeyDesc getSingleUniqueKeyDesc(ColumnDesc columnDesc) {
        UniqueKeyDesc uniqueKeyDesc = new UniqueKeyDesc();
        if (columnDesc.isUnique()) {
            String columnName = columnDesc.getName();
            uniqueKeyDesc.addColumnName(columnName);
        }
        if (uniqueKeyDesc.getColumnNameList().isEmpty()) {
            return null;
        }
        return uniqueKeyDesc;
    }
}

