/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileInputStreamUtil;

public class DeleteEmptyFileWriter
extends FilterWriter {
    protected boolean written;
    protected boolean deleted;
    protected File file;

    public DeleteEmptyFileWriter(Writer writer, File file) {
        super(writer);
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
    }

    public void close() throws IOException {
        super.close();
        if (!this.written && this.file.exists() && this.isEmpty()) {
            this.deleted = this.file.delete();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        this.written = true;
        super.write(cbuf, off, len);
    }

    public void write(int c) throws IOException {
        this.written = true;
        super.write(c);
    }

    public void write(String str, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        this.written = true;
        super.write(str, off, len);
    }

    protected boolean isEmpty() {
        FileInputStream is = FileInputStreamUtil.create((File)this.file);
        try {
            boolean bl = ((InputStream)is).read() == -1;
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

