/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.UserTransaction;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyEmptyRuntimeException;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlFileExecutor;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSqlCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(ExecuteSqlCommand.class);
    protected List<File> sqlFileList = new ArrayList<File>();
    protected String sqlFileEncoding = "UTF-8";
    protected char statementDelimiter = (char)59;
    protected String blockDelimiter = null;
    protected boolean haltOnError = true;
    protected boolean transactional = false;
    protected String genDialectClassName = null;
    protected GenDialect dialect;
    protected UserTransaction userTransaction;
    protected SqlFileExecutor sqlFileExecutor;
    protected SqlUnitExecutor sqlUnitExecutor;

    public String getBlockDelimiter() {
        return this.blockDelimiter;
    }

    public void setBlockDelimiter(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public String getSqlFileEncoding() {
        return this.sqlFileEncoding;
    }

    public void setSqlFileEncoding(String sqlFileEncoding) {
        this.sqlFileEncoding = sqlFileEncoding;
    }

    public List<File> getSqlFileList() {
        return this.sqlFileList;
    }

    public void setSqlFileList(List<File> sqlFileList) {
        this.sqlFileList = sqlFileList;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public char getStatementDelimiter() {
        return this.statementDelimiter;
    }

    public void setStatementDelimiter(char statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    @Override
    protected void doValidate() {
        if (this.sqlFileList.isEmpty()) {
            throw new RequiredPropertyEmptyRuntimeException("sqlFileList");
        }
    }

    @Override
    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        if (this.transactional) {
            this.userTransaction = (UserTransaction)SingletonS2Container.getComponent(UserTransaction.class);
        }
        this.sqlFileExecutor = this.createSqlFileExecutor();
        this.sqlUnitExecutor = this.createSqlUnitExecutor();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    @Override
    protected void doExecute() throws Throwable {
        this.sqlUnitExecutor.execute(new SqlUnitExecutor.Callback(){

            public void execute(SqlExecutionContext context) {
                for (File sqlFile : ExecuteSqlCommand.this.sqlFileList) {
                    ExecuteSqlCommand.this.sqlFileExecutor.execute(context, sqlFile);
                }
            }
        });
    }

    @Override
    protected void doDestroy() {
    }

    protected SqlFileExecutor createSqlFileExecutor() {
        return this.factory.createSqlFileExecutor(this, this.dialect, this.sqlFileEncoding, this.statementDelimiter, this.blockDelimiter);
    }

    protected SqlUnitExecutor createSqlUnitExecutor() {
        return this.factory.createSqlUnitExecutor(this, this.jdbcManager.getDataSource(), this.userTransaction, this.haltOnError);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

