/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import javax.transaction.UserTransaction;
import org.seasar.extension.jdbc.gen.data.Loader;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.DatabaseDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlFileExecutor;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.extension.jdbc.gen.version.Migrater;
import org.seasar.extension.jdbc.gen.version.SchemaInfoTable;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class MigrateCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(MigrateCommand.class);
    protected File classpathDir;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entityClassNamePattern = ".*";
    protected String ignoreEntityClassNamePattern = "";
    protected String schemaInfoFullTableName = "SCHEMA_INFO";
    protected String schemaInfoColumnName = "VERSION";
    protected File migrateDir = new File("db", "migrate");
    protected File ddlInfoFile = new File("db", "ddl-info.txt");
    protected String versionNoPattern = "0000";
    protected String version = "latest";
    protected boolean applyEnvToVersion;
    protected char statementDelimiter = (char)59;
    protected String blockDelimiter = null;
    protected String ddlFileEncoding = "UTF-8";
    protected String dumpFileEncoding = "UTF-8";
    protected boolean haltOnError = true;
    protected int loadBatchSize = 10;
    protected boolean transactional = false;
    protected String genDialectClassName = null;
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;
    protected UserTransaction userTransaction;
    protected EntityMetaReader entityMetaReader;
    protected SqlFileExecutor sqlFileExecutor;
    protected SchemaInfoTable schemaInfoTable;
    protected DdlVersionDirectoryTree ddlVersionDirectoryTree;
    protected Migrater migrater;
    protected DatabaseDescFactory databaseDescFactory;
    protected SqlUnitExecutor sqlUnitExecutor;
    protected Loader loader;

    public char getStatementDelimiter() {
        return this.statementDelimiter;
    }

    public void setStatementDelimiter(char statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public String getBlockDelimiter() {
        return this.blockDelimiter;
    }

    public void setBlockDelimiter(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public String getSchemaInfoFullTableName() {
        return this.schemaInfoFullTableName;
    }

    public void setSchemaInfoFullTableName(String schemaInfoFullTableName) {
        this.schemaInfoFullTableName = schemaInfoFullTableName;
    }

    public String getSchemaInfoColumnName() {
        return this.schemaInfoColumnName;
    }

    public void setSchemaInfoColumnName(String schemaInfoColumnName) {
        this.schemaInfoColumnName = schemaInfoColumnName;
    }

    public String getDdlFileEncoding() {
        return this.ddlFileEncoding;
    }

    public void setDdlFileEncoding(String ddlFileEncoding) {
        this.ddlFileEncoding = ddlFileEncoding;
    }

    public File getMigrateDir() {
        return this.migrateDir;
    }

    public void setMigrateDir(File migrateDir) {
        this.migrateDir = migrateDir;
    }

    public String getVersionNoPattern() {
        return this.versionNoPattern;
    }

    public void setVersionNoPattern(String versionNoPattern) {
        this.versionNoPattern = versionNoPattern;
    }

    public File getDdlInfoFile() {
        return this.ddlInfoFile;
    }

    public void setDdlInfoFile(File ddlInfoFile) {
        this.ddlInfoFile = ddlInfoFile;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityClassNamePattern() {
        return this.entityClassNamePattern;
    }

    public void setEntityClassNamePattern(String entityClassNamePattern) {
        this.entityClassNamePattern = entityClassNamePattern;
    }

    public String getIgnoreEntityClassNamePattern() {
        return this.ignoreEntityClassNamePattern;
    }

    public void setIgnoreEntityClassNamePattern(String ignoreEntityClassNamePattern) {
        this.ignoreEntityClassNamePattern = ignoreEntityClassNamePattern;
    }

    public String getDumpFileEncoding() {
        return this.dumpFileEncoding;
    }

    public void setDumpFileEncoding(String dumpFileEncoding) {
        this.dumpFileEncoding = dumpFileEncoding;
    }

    public int getLoadBatchSize() {
        return this.loadBatchSize;
    }

    public void setLoadBatchSize(int loadBatchSize) {
        this.loadBatchSize = loadBatchSize;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    public boolean isApplyEnvToVersion() {
        return this.applyEnvToVersion;
    }

    public void setApplyEnvToVersion(boolean applyEnvToVersion) {
        this.applyEnvToVersion = applyEnvToVersion;
    }

    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        this.valueTypeProvider = this.createValueTypeProvider();
        if (this.transactional) {
            this.userTransaction = (UserTransaction)SingletonS2Container.getComponent(UserTransaction.class);
        }
        this.sqlFileExecutor = this.createSqlFileExecutor();
        this.schemaInfoTable = this.createSchemaInfoTable();
        this.ddlVersionDirectoryTree = this.createDdlVersionDirectoryTree();
        this.entityMetaReader = this.createEntityMetaReader();
        this.databaseDescFactory = this.createDatabaseDescFactory();
        this.sqlUnitExecutor = this.createSqlUnitExecutor();
        this.loader = this.createLoader();
        this.migrater = this.createMigrater();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    protected void doExecute() {
        final DatabaseDesc databaseDesc = this.databaseDescFactory.getDatabaseDesc();
        this.migrater.migrate(new Migrater.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void drop(SqlExecutionContext sqlExecutionContext, File file) {
                if (MigrateCommand.this.sqlFileExecutor.isTarget(databaseDesc, file)) {
                    boolean haltOnError = sqlExecutionContext.isHaltOnError();
                    try {
                        sqlExecutionContext.setHaltOnError(false);
                        MigrateCommand.this.sqlFileExecutor.execute(sqlExecutionContext, file);
                    }
                    finally {
                        sqlExecutionContext.setHaltOnError(haltOnError);
                    }
                }
            }

            public void create(SqlExecutionContext sqlExecutionContext, File file) {
                if (MigrateCommand.this.sqlFileExecutor.isTarget(databaseDesc, file)) {
                    MigrateCommand.this.sqlFileExecutor.execute(sqlExecutionContext, file);
                }
                if (MigrateCommand.this.loader.isTarget(databaseDesc, file)) {
                    MigrateCommand.this.loader.load(sqlExecutionContext, databaseDesc, file);
                }
            }
        });
    }

    protected void doDestroy() {
    }

    protected EntityMetaReader createEntityMetaReader() {
        return this.factory.createEntityMetaReader(this, this.classpathDir, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), this.jdbcManager.getEntityMetaFactory(), this.entityClassNamePattern, this.ignoreEntityClassNamePattern, false, null, null);
    }

    protected DatabaseDescFactory createDatabaseDescFactory() {
        return this.factory.createDatabaseDescFactory(this, this.jdbcManager.getEntityMetaFactory(), this.entityMetaReader, this.dialect, this.valueTypeProvider, true);
    }

    protected SchemaInfoTable createSchemaInfoTable() {
        return this.factory.createSchemaInfoTable(this, this.jdbcManager.getDataSource(), this.dialect, this.schemaInfoFullTableName, this.schemaInfoColumnName);
    }

    protected DdlVersionDirectoryTree createDdlVersionDirectoryTree() {
        return this.factory.createDdlVersionDirectoryTree(this, this.migrateDir, this.ddlInfoFile, this.versionNoPattern, this.env, this.applyEnvToVersion);
    }

    protected Migrater createMigrater() {
        return this.factory.createMigrater(this, this.sqlUnitExecutor, this.schemaInfoTable, this.ddlVersionDirectoryTree, this.version, this.env);
    }

    protected SqlFileExecutor createSqlFileExecutor() {
        return this.factory.createSqlFileExecutor(this, this.dialect, this.ddlFileEncoding, this.statementDelimiter, this.blockDelimiter);
    }

    protected SqlUnitExecutor createSqlUnitExecutor() {
        return this.factory.createSqlUnitExecutor(this, this.jdbcManager.getDataSource(), this.userTransaction, this.haltOnError);
    }

    protected Loader createLoader() {
        return this.factory.createLoader(this, this.dialect, this.dumpFileEncoding, this.loadBatchSize, false);
    }

    protected ValueTypeProvider createValueTypeProvider() {
        return this.factory.createValueTypeProvider(this, this.jdbcManager.getDialect());
    }

    protected Logger getLogger() {
        return logger;
    }
}

