/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.exception.UnsupportedSqlTypeRuntimeException;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GenDialect {
    public String getName();

    public String getDefaultSchemaName(String var1);

    public SqlType getSqlType(int var1) throws UnsupportedSqlTypeRuntimeException;

    public SqlType getSqlType(ValueTypeProvider var1, PropertyMeta var2);

    public ColumnType getColumnType(String var1, int var2);

    public GenerationType getDefaultGenerationType();

    public String getOpenQuote();

    public String getCloseQuote();

    public String quote(String var1);

    public String unquote(String var1);

    public boolean supportsSequence();

    public boolean supportsGetIndexInfo(String var1, String var2, String var3);

    public String getSequenceDefinitionFragment(String var1, long var2, int var4);

    public String getSqlBlockDelimiter();

    public String getIdentityColumnDefinition();

    public String getDropForeignKeySyntax();

    public String getDropUniqueKeySyntax();

    public boolean isTableNotFound(Throwable var1);

    public boolean isColumnNotFound(Throwable var1);

    public boolean isSequenceNotFound(Throwable var1);

    public SqlBlockContext createSqlBlockContext();

    public boolean supportsIdentityInsert();

    public boolean supportsIdentityInsertControlStatement();

    public String getIdentityInsertEnableStatement(String var1);

    public String getIdentityInsertDisableStatement(String var1);

    public boolean supportsNullableUnique();

    public boolean supportsIdentity();

    public String getSequenceNextValString(String var1, int var2);

    public boolean supportsCommentInCreateTable();

    public boolean supportsCommentOn();

    public boolean isJdbcCommentAvailable();

    public String getTableComment(Connection var1, String var2, String var3, String var4) throws SQLException;

    public Map<String, String> getColumnCommentMap(Connection var1, String var2, String var3, String var4) throws SQLException;

    public boolean supportsReferentialDeleteRule();

    public boolean supportsReferentialUpdateRule();

    public boolean isAutoIncrement(Connection var1, String var2, String var3, String var4, String var5) throws SQLException;

    public static interface SqlBlockContext {
        public void addKeyword(String var1);

        public boolean isInSqlBlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ColumnType {
        public Class<?> getAttributeClass(int var1, int var2, int var3);

        public String getColumnDefinition(int var1, int var2, int var3, String var4);

        public boolean isLob();

        public TemporalType getTemporalType();
    }
}

