/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.exception.UnsupportedSqlTypeRuntimeException;
import org.seasar.extension.jdbc.gen.internal.sqltype.BigIntType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.CharType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DateType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.FloatType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;
import org.seasar.extension.jdbc.gen.internal.sqltype.SmallIntType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimeType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimestampType;
import org.seasar.extension.jdbc.gen.internal.sqltype.VarcharType;
import org.seasar.extension.jdbc.gen.internal.util.ColumnUtil;
import org.seasar.extension.jdbc.gen.internal.util.TableUtil;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sqltype.SqlType;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardGenDialect
implements GenDialect {
    protected static Logger logger = Logger.getLogger(StandardGenDialect.class);
    protected Map<Integer, SqlType> sqlTypeMap = new HashMap<Integer, SqlType>();
    protected Map<Object, GenDialect.ColumnType> columnTypeMap = new CaseInsensitiveMap();
    protected Map<Integer, GenDialect.ColumnType> fallbackColumnTypeMap = new HashMap<Integer, GenDialect.ColumnType>();

    public StandardGenDialect() {
        this.sqlTypeMap.put(-5, new BigIntType());
        this.sqlTypeMap.put(-2, new BinaryType());
        this.sqlTypeMap.put(2004, new BlobType());
        this.sqlTypeMap.put(16, new BooleanType());
        this.sqlTypeMap.put(1, new CharType());
        this.sqlTypeMap.put(2005, new ClobType());
        this.sqlTypeMap.put(91, new DateType());
        this.sqlTypeMap.put(3, new DecimalType());
        this.sqlTypeMap.put(8, new DoubleType());
        this.sqlTypeMap.put(6, new FloatType());
        this.sqlTypeMap.put(4, new IntegerType());
        this.sqlTypeMap.put(5, new SmallIntType());
        this.sqlTypeMap.put(92, new TimeType());
        this.sqlTypeMap.put(93, new TimestampType());
        this.sqlTypeMap.put(12, new VarcharType());
        this.columnTypeMap.put("bigint", StandardColumnType.BIGINT);
        this.columnTypeMap.put("binary", StandardColumnType.BINARY);
        this.columnTypeMap.put("bit", StandardColumnType.BIT);
        this.columnTypeMap.put("blob", StandardColumnType.BLOB);
        this.columnTypeMap.put("boolean", StandardColumnType.BOOLEAN);
        this.columnTypeMap.put("char", StandardColumnType.CHAR);
        this.columnTypeMap.put("clob", StandardColumnType.CLOB);
        this.columnTypeMap.put("date", StandardColumnType.DATE);
        this.columnTypeMap.put("decimal", StandardColumnType.DECIMAL);
        this.columnTypeMap.put("double", StandardColumnType.DOUBLE);
        this.columnTypeMap.put("float", StandardColumnType.FLOAT);
        this.columnTypeMap.put("integer", StandardColumnType.INTEGER);
        this.columnTypeMap.put("longvarbinary", StandardColumnType.LONGVARBINARY);
        this.columnTypeMap.put("longvarchar", StandardColumnType.LONGVARCHAR);
        this.columnTypeMap.put("numeric", StandardColumnType.NUMERIC);
        this.columnTypeMap.put("real", StandardColumnType.REAL);
        this.columnTypeMap.put("smallint", StandardColumnType.SMALLINT);
        this.columnTypeMap.put("time", StandardColumnType.TIME);
        this.columnTypeMap.put("timestamp", StandardColumnType.TIMESTAMP);
        this.columnTypeMap.put("tinyint", StandardColumnType.TINYINT);
        this.columnTypeMap.put("varbinary", StandardColumnType.VARBINARY);
        this.columnTypeMap.put("varchar", StandardColumnType.VARCHAR);
        this.fallbackColumnTypeMap.put(-5, StandardColumnType.BIGINT);
        this.fallbackColumnTypeMap.put(-2, StandardColumnType.BINARY);
        this.fallbackColumnTypeMap.put(-7, StandardColumnType.BIT);
        this.fallbackColumnTypeMap.put(2004, StandardColumnType.BLOB);
        this.fallbackColumnTypeMap.put(16, StandardColumnType.BOOLEAN);
        this.fallbackColumnTypeMap.put(1, StandardColumnType.CHAR);
        this.fallbackColumnTypeMap.put(2005, StandardColumnType.CLOB);
        this.fallbackColumnTypeMap.put(91, StandardColumnType.DATE);
        this.fallbackColumnTypeMap.put(3, StandardColumnType.DECIMAL);
        this.fallbackColumnTypeMap.put(8, StandardColumnType.DOUBLE);
        this.fallbackColumnTypeMap.put(6, StandardColumnType.FLOAT);
        this.fallbackColumnTypeMap.put(4, StandardColumnType.INTEGER);
        this.fallbackColumnTypeMap.put(-4, StandardColumnType.LONGVARBINARY);
        this.fallbackColumnTypeMap.put(-1, StandardColumnType.LONGVARCHAR);
        this.fallbackColumnTypeMap.put(2, StandardColumnType.NUMERIC);
        this.fallbackColumnTypeMap.put(7, StandardColumnType.REAL);
        this.fallbackColumnTypeMap.put(5, StandardColumnType.SMALLINT);
        this.fallbackColumnTypeMap.put(92, StandardColumnType.TIME);
        this.fallbackColumnTypeMap.put(93, StandardColumnType.TIMESTAMP);
        this.fallbackColumnTypeMap.put(-6, StandardColumnType.TINYINT);
        this.fallbackColumnTypeMap.put(-3, StandardColumnType.VARBINARY);
        this.fallbackColumnTypeMap.put(12, StandardColumnType.VARCHAR);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDefaultSchemaName(String userName) {
        return userName;
    }

    @Override
    public SqlType getSqlType(int sqlType) {
        return this.getSqlTypeInternal(sqlType);
    }

    @Override
    public SqlType getSqlType(ValueTypeProvider valueTypeProvider, PropertyMeta propertyMeta) {
        ValueType valueType = valueTypeProvider.provide(propertyMeta);
        return this.getSqlTypeInternal(valueType.getSqlType());
    }

    protected SqlType getSqlTypeInternal(int sqlType) {
        SqlType type = this.sqlTypeMap.get(sqlType);
        if (type != null) {
            return type;
        }
        throw new UnsupportedSqlTypeRuntimeException(sqlType);
    }

    @Override
    public GenDialect.ColumnType getColumnType(String typeName, int sqlType) {
        GenDialect.ColumnType columnType = this.columnTypeMap.get(typeName);
        return columnType != null ? columnType : this.fallbackColumnTypeMap.get(sqlType);
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.TABLE;
    }

    @Override
    public String getOpenQuote() {
        return "\"";
    }

    @Override
    public String getCloseQuote() {
        return "\"";
    }

    @Override
    public String quote(String value) {
        if (value == null) {
            return null;
        }
        return this.getOpenQuote() + value + this.getCloseQuote();
    }

    @Override
    public String unquote(String value) {
        String s = StringUtil.ltrim((String)value, (String)this.getOpenQuote());
        return StringUtil.rtrim((String)s, (String)this.getCloseQuote());
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public boolean supportsGetIndexInfo(String catalogName, String schemaName, String tableName) {
        return true;
    }

    @Override
    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        throw new UnsupportedOperationException("getSequenceDefinitionFragment");
    }

    @Override
    public String getSqlBlockDelimiter() {
        return null;
    }

    @Override
    public String getIdentityColumnDefinition() {
        throw new UnsupportedOperationException("getIdentityDefinition");
    }

    @Override
    public String getDropForeignKeySyntax() {
        return "drop constraint";
    }

    @Override
    public String getDropUniqueKeySyntax() {
        return "drop constraint";
    }

    @Override
    public boolean isTableNotFound(Throwable throwable) {
        return false;
    }

    @Override
    public boolean isColumnNotFound(Throwable throwable) {
        return false;
    }

    @Override
    public boolean isSequenceNotFound(Throwable throwable) {
        return false;
    }

    @Override
    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new StandardSqlBlockContext();
    }

    @Override
    public boolean supportsIdentityInsert() {
        return false;
    }

    @Override
    public boolean supportsIdentityInsertControlStatement() {
        return false;
    }

    @Override
    public String getIdentityInsertEnableStatement(String tableName) {
        throw new UnsupportedOperationException("getIdentityInsertOnStatement");
    }

    @Override
    public String getIdentityInsertDisableStatement(String tableName) {
        throw new UnsupportedOperationException("getIdentityInsertOffStatement");
    }

    @Override
    public boolean supportsNullableUnique() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return false;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        throw new UnsupportedOperationException("getSequenceNextValString");
    }

    @Override
    public boolean supportsCommentInCreateTable() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return false;
    }

    @Override
    public boolean isJdbcCommentAvailable() {
        return true;
    }

    @Override
    public String getTableComment(Connection connection, String catalogName, String schemaName, String tableName) throws SQLException {
        throw new UnsupportedOperationException("getTableComment");
    }

    @Override
    public Map<String, String> getColumnCommentMap(Connection connection, String catalogName, String schemaName, String tableName) throws SQLException {
        throw new UnsupportedOperationException("getColumnCommentMap");
    }

    @Override
    public boolean supportsReferentialDeleteRule() {
        return true;
    }

    @Override
    public boolean supportsReferentialUpdateRule() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoIncrement(Connection connection, String catalogName, String schemaName, String tableName, String columnName) throws SQLException {
        String fullTableName = TableUtil.buildFullTableName(catalogName, schemaName, tableName);
        String sql = "select " + columnName + " from " + fullTableName + " where 1 = 0";
        logger.debug((Object)sql);
        PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)connection, (String)sql);
        try {
            boolean bl;
            ResultSet rs = ps.executeQuery();
            try {
                ResultSetMetaData rsMetaData = rs.getMetaData();
                bl = rsMetaData.isAutoIncrement(1);
            }
            catch (Throwable throwable) {
                ResultSetUtil.close((ResultSet)rs);
                throw throwable;
            }
            ResultSetUtil.close((ResultSet)rs);
            return bl;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }

    protected String getSQLState(Throwable t) {
        SQLException cause = this.getCauseSQLException(t);
        if (cause != null && !StringUtil.isEmpty((String)cause.getSQLState())) {
            return cause.getSQLState();
        }
        return null;
    }

    protected Integer getErrorCode(Throwable t) {
        SQLException cause = this.getCauseSQLException(t);
        if (cause != null) {
            return cause.getErrorCode();
        }
        return null;
    }

    protected SQLException getCauseSQLException(Throwable t) {
        SQLException cause = null;
        while (t != null) {
            if (t instanceof SQLException && (cause = (SQLException)SQLException.class.cast(t)).getNextException() != null) {
                cause = cause.getNextException();
                t = cause;
                continue;
            }
            t = t.getCause();
        }
        return cause;
    }

    public static class StandardSqlBlockContext
    implements GenDialect.SqlBlockContext {
        protected List<List<String>> sqlBlockStartKeywordsList = new ArrayList<List<String>>();
        protected List<String> keywords = new ArrayList<String>();
        protected boolean inSqlBlock;

        public void addKeyword(String keyword) {
            if (!this.inSqlBlock) {
                this.keywords.add(keyword);
                this.check();
            }
        }

        protected void check() {
            for (List<String> startKeywords : this.sqlBlockStartKeywordsList) {
                if (startKeywords.size() > this.keywords.size()) continue;
                for (int i = 0; i < startKeywords.size(); ++i) {
                    String word1 = startKeywords.get(i);
                    String word2 = this.keywords.get(i);
                    this.inSqlBlock = word1.equalsIgnoreCase(word2);
                    if (!this.inSqlBlock) break;
                }
                if (!this.inSqlBlock) continue;
                break;
            }
        }

        public boolean isInSqlBlock() {
            return this.inSqlBlock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardColumnType
    implements GenDialect.ColumnType {
        private static StandardColumnType BIGINT = new StandardColumnType("bigint", Long.class);
        private static StandardColumnType BINARY = new StandardColumnType("binary", byte[].class);
        private static StandardColumnType BIT = new StandardColumnType("bit", Boolean.class);
        private static StandardColumnType BLOB = new StandardColumnType("blob", byte[].class, true);
        private static StandardColumnType BOOLEAN = new StandardColumnType("boolean", Boolean.class);
        private static StandardColumnType CHAR = new StandardColumnType("char($l)", String.class);
        private static StandardColumnType CLOB = new StandardColumnType("clob", String.class, true);
        private static StandardColumnType DATE = new StandardColumnType("date", Date.class);
        private static StandardColumnType DECIMAL = new StandardColumnType("decimal", BigDecimal.class);
        private static StandardColumnType DOUBLE = new StandardColumnType("double", Double.class);
        private static StandardColumnType FLOAT = new StandardColumnType("float", Float.class);
        private static StandardColumnType INTEGER = new StandardColumnType("integer", Integer.class);
        private static StandardColumnType LONGVARBINARY = new StandardColumnType("longvarbinary", byte[].class);
        private static StandardColumnType LONGVARCHAR = new StandardColumnType("longvarchar", String.class);
        private static StandardColumnType NUMERIC = new StandardColumnType("numeric", BigDecimal.class);
        private static StandardColumnType REAL = new StandardColumnType("real", Float.class);
        private static StandardColumnType SMALLINT = new StandardColumnType("smallint", Short.class);
        private static StandardColumnType TIME = new StandardColumnType("time", Time.class);
        private static StandardColumnType TIMESTAMP = new StandardColumnType("timestamp", Timestamp.class);
        private static StandardColumnType TINYINT = new StandardColumnType("tinyint", Short.class);
        private static StandardColumnType VARBINARY = new StandardColumnType("varbinary($l)", byte[].class);
        private static StandardColumnType VARCHAR = new StandardColumnType("varchar($l)", String.class);
        protected String dataType;
        protected Class<?> attributeClass;
        protected boolean lob;
        protected TemporalType temporalType;

        protected StandardColumnType(String dataType, Class<?> attributeClass) {
            this(dataType, attributeClass, false);
        }

        protected StandardColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            this(dataType, attributeClass, lob, null);
        }

        protected StandardColumnType(String dataType, Class<?> attributeClass, boolean lob, TemporalType temporalType) {
            this.dataType = dataType;
            this.attributeClass = attributeClass;
            this.lob = lob;
            this.temporalType = temporalType;
        }

        @Override
        public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
            String completeDataType = ColumnUtil.formatDataType(this.dataType, length, precision, scale);
            return this.getColumnDefinitionInternal(completeDataType, defaultValue);
        }

        protected String getColumnDefinitionInternal(String completeDataType, String defaultValue) {
            if (defaultValue == null) {
                return completeDataType;
            }
            return completeDataType + " default " + defaultValue;
        }

        @Override
        public Class<?> getAttributeClass(int length, int precision, int scale) {
            return this.attributeClass;
        }

        @Override
        public boolean isLob() {
            return this.lob;
        }

        @Override
        public TemporalType getTemporalType() {
            return this.temporalType;
        }
    }
}

