/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.TableMeta;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.ColumnDescFactory;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDesc;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDescFactory;
import org.seasar.extension.jdbc.gen.desc.IdTableDescFactory;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDesc;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDescFactory;
import org.seasar.extension.jdbc.gen.desc.SequenceDesc;
import org.seasar.extension.jdbc.gen.desc.SequenceDescFactory;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.desc.TableDescFactory;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.internal.util.EntityMetaUtil;
import org.seasar.extension.jdbc.gen.internal.util.TableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDescFactoryImpl
implements TableDescFactory {
    protected ConcurrentMap<String, TableDesc> tableDescMap = new ConcurrentHashMap<String, TableDesc>(200);
    protected GenDialect dialect;
    protected ColumnDescFactory columnDescFactory;
    protected PrimaryKeyDescFactory primaryKeyDescFactory;
    protected ForeignKeyDescFactory foreignKeyDescFactory;
    protected UniqueKeyDescFactory uniqueKeyDescFactory;
    protected SequenceDescFactory sequenceDescFactory;
    protected IdTableDescFactory idTableDescFactory;

    public TableDescFactoryImpl(GenDialect dialect, ColumnDescFactory columnDescFactory, PrimaryKeyDescFactory primaryKeyDescFactory, UniqueKeyDescFactory uniqueKeyDescFactory, ForeignKeyDescFactory foreignKeyDescFactory, SequenceDescFactory sequenceDescFactory, IdTableDescFactory idTableDescFactory) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (columnDescFactory == null) {
            throw new NullPointerException("columnDescFactory");
        }
        if (primaryKeyDescFactory == null) {
            throw new NullPointerException("primaryKeyDescFactory");
        }
        if (uniqueKeyDescFactory == null) {
            throw new NullPointerException("uniqueKeyDescFactory");
        }
        if (foreignKeyDescFactory == null) {
            throw new NullPointerException("foreignKeyDescFactory");
        }
        if (sequenceDescFactory == null) {
            throw new NullPointerException("sequenceDescFactory");
        }
        if (idTableDescFactory == null) {
            throw new NullPointerException("idTableDescFactory");
        }
        this.dialect = dialect;
        this.columnDescFactory = columnDescFactory;
        this.primaryKeyDescFactory = primaryKeyDescFactory;
        this.uniqueKeyDescFactory = uniqueKeyDescFactory;
        this.foreignKeyDescFactory = foreignKeyDescFactory;
        this.sequenceDescFactory = sequenceDescFactory;
        this.idTableDescFactory = idTableDescFactory;
    }

    @Override
    public TableDesc getTableDesc(EntityMeta entityMeta) {
        String fullName = entityMeta.getTableMeta().getFullName().toLowerCase();
        TableDesc tableDesc = (TableDesc)this.tableDescMap.get(fullName);
        if (tableDesc != null) {
            return tableDesc;
        }
        tableDesc = this.createTableDesc(entityMeta);
        this.tableDescMap.put(fullName, tableDesc);
        return tableDesc;
    }

    protected TableDesc createTableDesc(EntityMeta entityMeta) {
        Table table = this.getTable(entityMeta);
        TableDesc tableDesc = new TableDesc();
        this.doName(entityMeta, tableDesc, table);
        this.doComment(entityMeta, tableDesc, table);
        this.doPrimaryKeyDesc(entityMeta, tableDesc, table);
        this.doColumnDesc(entityMeta, tableDesc, table);
        this.doForeignKeyDesc(entityMeta, tableDesc, table);
        this.doUniqueKeyDesc(entityMeta, tableDesc, table);
        this.doSequenceDesc(entityMeta, tableDesc, table);
        this.doIdTableDesc(entityMeta, tableDesc, table);
        return tableDesc;
    }

    protected void doName(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        TableMeta tableMeta = entityMeta.getTableMeta();
        tableDesc.setCatalogName(tableMeta.getCatalog());
        tableDesc.setSchemaName(tableMeta.getSchema());
        tableDesc.setName(tableMeta.getName());
        tableDesc.setCanonicalName(this.buildCanonicalName(tableMeta));
    }

    protected void doComment(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        String comment = EntityMetaUtil.getComment(entityMeta);
        tableDesc.setComment(comment);
    }

    protected String buildCanonicalName(TableMeta tableMeta) {
        return TableUtil.buildCanonicalTableName(this.dialect, tableMeta.getCatalog(), tableMeta.getSchema(), tableMeta.getName());
    }

    protected void doColumnDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        ArrayList<ColumnDescRef> columnDescRefList = new ArrayList<ColumnDescRef>();
        for (int i = 0; i < entityMeta.getColumnPropertyMetaSize(); ++i) {
            PropertyMeta propertyMeta = entityMeta.getColumnPropertyMeta(i);
            ColumnDesc columnDesc = this.columnDescFactory.getColumnDesc(entityMeta, propertyMeta);
            if (columnDesc == null) continue;
            columnDescRefList.add(new ColumnDescRef(i, columnDesc));
        }
        Collections.sort(columnDescRefList, this.createColumnDescRefComparator(tableDesc));
        for (ColumnDescRef columnDescRef : columnDescRefList) {
            tableDesc.addColumnDesc(columnDescRef.columnDesc);
        }
    }

    protected void doPrimaryKeyDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        PrimaryKeyDesc primaryKeyDesc = this.primaryKeyDescFactory.getPrimaryKeyDesc(entityMeta);
        if (primaryKeyDesc != null) {
            tableDesc.setPrimaryKeyDesc(primaryKeyDesc);
        }
    }

    protected void doForeignKeyDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        for (int i = 0; i < entityMeta.getPropertyMetaSize(); ++i) {
            PropertyMeta propertyMeta = entityMeta.getPropertyMeta(i);
            ForeignKeyDesc foreignKeyDesc = this.foreignKeyDescFactory.getForeignKeyDesc(entityMeta, propertyMeta);
            if (foreignKeyDesc == null) continue;
            tableDesc.addForeignKeyDesc(foreignKeyDesc);
        }
    }

    protected void doUniqueKeyDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        String singlePkColumnName = null;
        PrimaryKeyDesc primaryKeyDesc = tableDesc.getPrimaryKeyDesc();
        if (primaryKeyDesc != null && primaryKeyDesc.getColumnNameList().size() == 1) {
            singlePkColumnName = primaryKeyDesc.getColumnNameList().get(0);
        }
        for (ColumnDesc columnDesc : tableDesc.getColumnDescList()) {
            UniqueKeyDesc uniqueKeyDesc;
            if (columnDesc.getName().equals(singlePkColumnName) || (uniqueKeyDesc = this.uniqueKeyDescFactory.getSingleUniqueKeyDesc(columnDesc)) == null) continue;
            tableDesc.addUniqueKeyDesc(uniqueKeyDesc);
        }
        for (UniqueConstraint uc : table.uniqueConstraints()) {
            UniqueKeyDesc uniqueKeyDesc = this.uniqueKeyDescFactory.getCompositeUniqueKeyDesc(uc);
            if (uniqueKeyDesc == null) continue;
            tableDesc.addUniqueKeyDesc(uniqueKeyDesc);
        }
    }

    protected void doSequenceDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        for (PropertyMeta propertyMeta : entityMeta.getIdPropertyMetaList()) {
            SequenceDesc sequenceDesc = this.sequenceDescFactory.getSequenceDesc(entityMeta, propertyMeta);
            if (sequenceDesc == null) continue;
            tableDesc.addSequenceDesc(sequenceDesc);
        }
    }

    protected void doIdTableDesc(EntityMeta entityMeta, TableDesc tableDesc, Table table) {
        for (PropertyMeta propertyMeta : entityMeta.getIdPropertyMetaList()) {
            TableDesc idTableDesc = this.idTableDescFactory.getTableDesc(entityMeta, propertyMeta);
            if (idTableDesc == null) continue;
            tableDesc.addIdTableDesc(idTableDesc);
            String fullName = idTableDesc.getFullName().toLowerCase();
            TableDesc cache = (TableDesc)this.tableDescMap.get(fullName);
            if (cache == null) {
                this.tableDescMap.put(fullName, idTableDesc);
                continue;
            }
            cache.setCatalogName(idTableDesc.getCatalogName());
            cache.setSchemaName(idTableDesc.getSchemaName());
            cache.setName(idTableDesc.getName());
            cache.setPrimaryKeyDesc(idTableDesc.getPrimaryKeyDesc());
            for (ColumnDesc columnDesc : idTableDesc.getColumnDescList()) {
                cache.addColumnDesc(columnDesc);
            }
            for (UniqueKeyDesc uniqueKeyDesc : idTableDesc.getUniqueKeyDescList()) {
                cache.addUniqueKeyDesc(uniqueKeyDesc);
            }
        }
    }

    protected Table getTable(EntityMeta entityMeta) {
        Class clazz = entityMeta.getEntityClass();
        Table table = clazz.getAnnotation(Table.class);
        return table != null ? table : AnnotationUtil.getDefaultTable();
    }

    protected Comparator<ColumnDescRef> createColumnDescRefComparator(TableDesc tableDesc) {
        final ArrayList<String> pkColumnNameList = new ArrayList<String>();
        if (tableDesc.getPrimaryKeyDesc() != null) {
            PrimaryKeyDesc primaryKeyDesc = tableDesc.getPrimaryKeyDesc();
            pkColumnNameList.addAll(primaryKeyDesc.getColumnNameList());
        }
        return new Comparator<ColumnDescRef>(){

            @Override
            public int compare(ColumnDescRef o1, ColumnDescRef o2) {
                int index1 = pkColumnNameList.indexOf(o1.columnDesc.getName());
                int index2 = pkColumnNameList.indexOf(o2.columnDesc.getName());
                int ret = 0;
                ret = index1 < 0 ? (index2 < 0 ? o1.index - o2.index : 1) : (index2 < 0 ? -1 : index1 - index2);
                return ret;
            }
        };
    }

    private static class ColumnDescRef {
        final int index;
        final ColumnDesc columnDesc;

        ColumnDescRef(int index, ColumnDesc desc) {
            this.index = index;
            this.columnDesc = desc;
        }
    }
}

