/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.gen.desc.SequenceDesc;
import org.seasar.extension.jdbc.gen.desc.SequenceDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.exception.UnsupportedGenerationTypeRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

public class SequenceDescFactoryImpl
implements SequenceDescFactory {
    protected static Logger logger = Logger.getLogger(SequenceDescFactoryImpl.class);
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;

    public SequenceDescFactoryImpl(GenDialect dialect, ValueTypeProvider valueTypeProvider) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (valueTypeProvider == null) {
            throw new NullPointerException("valueTypeResolver");
        }
        this.dialect = dialect;
        this.valueTypeProvider = valueTypeProvider;
    }

    public SequenceDesc getSequenceDesc(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        GenerationType generationType = propertyMeta.getGenerationType();
        if (generationType == GenerationType.AUTO) {
            generationType = this.dialect.getDefaultGenerationType();
        }
        if (generationType == GenerationType.SEQUENCE) {
            if (!this.dialect.supportsSequence()) {
                throw new UnsupportedGenerationTypeRuntimeException(GenerationType.SEQUENCE, entityMeta.getName(), propertyMeta.getName());
            }
            SequenceGenerator generator = this.getSequenceGenerator(entityMeta, propertyMeta);
            SequenceDesc sequenceDesc = new SequenceDesc();
            String sequenceName = this.getSequenceName(entityMeta, propertyMeta, generator);
            sequenceDesc.setSequenceName(sequenceName);
            sequenceDesc.setInitialValue(generator.initialValue());
            sequenceDesc.setAllocationSize(generator.allocationSize());
            sequenceDesc.setDataType(this.getDataType(propertyMeta));
            return sequenceDesc;
        }
        return null;
    }

    protected SequenceGenerator getSequenceGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        Field field = propertyMeta.getField();
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            throw new IllegalStateException("@GeneratedValue not found.");
        }
        String name = generatedValue.generator();
        if (StringUtil.isEmpty((String)name)) {
            return AnnotationUtil.getDefaultSequenceGenerator();
        }
        SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null && name.equals(sequenceGenerator.name())) {
            return sequenceGenerator;
        }
        sequenceGenerator = entityMeta.getEntityClass().getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null && name.equals(sequenceGenerator.name())) {
            return sequenceGenerator;
        }
        throw new IllegalStateException("@SequenceGenerator not found.");
    }

    protected String getSequenceName(EntityMeta entityMeta, PropertyMeta propertyMeta, SequenceGenerator sequenceGenerator) {
        String sequenceName = sequenceGenerator.sequenceName();
        if (!StringUtil.isEmpty((String)sequenceName)) {
            return sequenceName;
        }
        return entityMeta.getTableMeta().getName() + "_" + propertyMeta.getColumnMeta().getName();
    }

    protected String getDataType(PropertyMeta propertyMeta) {
        ValueType valueType = this.valueTypeProvider.provide(propertyMeta);
        int sqlType = valueType.getSqlType();
        Column column = this.getColumn(propertyMeta);
        return this.dialect.getSqlType(sqlType).getDataType(column.length(), column.precision(), column.scale(), false);
    }

    protected Column getColumn(PropertyMeta propertyMeta) {
        Field field = propertyMeta.getField();
        Column column = field.getAnnotation(Column.class);
        return column != null ? column : AnnotationUtil.getDefaultColumn();
    }
}

