/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.EntityMetaFactory;
import org.seasar.extension.jdbc.gen.desc.ColumnDescFactory;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.DatabaseDescFactory;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDescFactory;
import org.seasar.extension.jdbc.gen.desc.IdTableDescFactory;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDescFactory;
import org.seasar.extension.jdbc.gen.desc.SequenceDescFactory;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.desc.TableDescFactory;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.desc.ColumnDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.ForeignKeyDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.IdTableDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.PrimaryKeyDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.SequenceDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.TableDescFactoryImpl;
import org.seasar.extension.jdbc.gen.internal.desc.UniqueKeyDescFactoryImpl;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;

public class DatabaseDescFactoryImpl
implements DatabaseDescFactory {
    protected EntityMetaFactory entityMetaFactory;
    protected EntityMetaReader entityMetaReader;
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;
    protected boolean regardRelationshipAsFk;
    protected TableDescFactory tableDescFactory;

    public DatabaseDescFactoryImpl(EntityMetaFactory entityMetaFactory, EntityMetaReader entityMetaReader, GenDialect dialect, ValueTypeProvider valueTypeProvider, boolean regardRelationshipAsFk) {
        if (entityMetaFactory == null) {
            throw new NullPointerException("entityMetaFactory");
        }
        if (entityMetaReader == null) {
            throw new NullPointerException("entityMetaReader");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (valueTypeProvider == null) {
            throw new NullPointerException("valueTypeResolver");
        }
        this.entityMetaFactory = entityMetaFactory;
        this.entityMetaReader = entityMetaReader;
        this.dialect = dialect;
        this.valueTypeProvider = valueTypeProvider;
        this.regardRelationshipAsFk = regardRelationshipAsFk;
        this.tableDescFactory = this.createTableDescFactory();
    }

    public DatabaseDesc getDatabaseDesc() {
        DatabaseDesc databaseDesc = new DatabaseDesc();
        databaseDesc.setFiltered(this.entityMetaReader.isFiltered());
        for (EntityMeta entityMeta : this.entityMetaReader.read()) {
            TableDesc tableDesc = this.tableDescFactory.getTableDesc(entityMeta);
            databaseDesc.addTableDesc(tableDesc);
            for (TableDesc idTableDesc : tableDesc.getIdTableDescList()) {
                databaseDesc.addTableDesc(idTableDesc);
            }
        }
        return databaseDesc;
    }

    protected TableDescFactory createTableDescFactory() {
        ColumnDescFactory colFactory = this.createColumnDescFactory();
        PrimaryKeyDescFactory pkFactory = this.createPrimaryKeyDescFactory();
        UniqueKeyDescFactory ukFactory = this.createUniqueKeyDescFactory();
        ForeignKeyDescFactory fkFactory = this.createForeignKeyDescFactory();
        SequenceDescFactory seqFactory = this.createSequenceDescFactory();
        IdTableDescFactory idTabFactory = this.createIdTableDescFactory(ukFactory);
        return new TableDescFactoryImpl(this.dialect, colFactory, pkFactory, ukFactory, fkFactory, seqFactory, idTabFactory);
    }

    protected ColumnDescFactory createColumnDescFactory() {
        return new ColumnDescFactoryImpl(this.dialect, this.valueTypeProvider);
    }

    protected PrimaryKeyDescFactory createPrimaryKeyDescFactory() {
        return new PrimaryKeyDescFactoryImpl(this.dialect);
    }

    protected UniqueKeyDescFactory createUniqueKeyDescFactory() {
        return new UniqueKeyDescFactoryImpl(this.dialect);
    }

    protected ForeignKeyDescFactory createForeignKeyDescFactory() {
        return new ForeignKeyDescFactoryImpl(this.dialect, this.entityMetaFactory, this.regardRelationshipAsFk);
    }

    protected SequenceDescFactory createSequenceDescFactory() {
        return new SequenceDescFactoryImpl(this.dialect, this.valueTypeProvider);
    }

    protected IdTableDescFactory createIdTableDescFactory(UniqueKeyDescFactory ukFactory) {
        return new IdTableDescFactoryImpl(this.dialect, ukFactory);
    }
}

