/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.sql.SqlFileTokenizer;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;

public class SqlFileReader {
    protected static Logger logger = Logger.getLogger(SqlFileReader.class);
    protected File sqlFile;
    protected String sqlFileEncoding;
    protected SqlFileTokenizer tokenizer;
    protected GenDialect dialect;
    protected BufferedReader reader;
    protected int lineCount;
    protected int lineNumber;
    protected boolean endOfFile;
    protected boolean endOfLine = true;

    public SqlFileReader(File sqlFile, String sqlFileEncoding, SqlFileTokenizer tokenizer, GenDialect dialect) {
        if (sqlFile == null) {
            throw new NullPointerException("sqlFile");
        }
        if (sqlFileEncoding == null) {
            throw new NullPointerException("sqlFileEncoding");
        }
        if (tokenizer == null) {
            throw new NullPointerException("tokenizer");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.sqlFile = sqlFile;
        this.sqlFileEncoding = sqlFileEncoding;
        this.tokenizer = tokenizer;
        this.dialect = dialect;
    }

    public String readSql() {
        if (this.endOfFile) {
            return null;
        }
        try {
            if (this.reader == null) {
                this.reader = this.createBufferedReader();
            }
            SqlBuilder builder = new SqlBuilder();
            do {
                if (this.endOfLine) {
                    ++this.lineCount;
                    this.tokenizer.addLine(this.reader.readLine());
                    builder.notifyLineChanged();
                }
                do {
                    builder.build(this.tokenizer.nextToken(), this.tokenizer.getToken());
                } while (builder.isTokenRequired());
            } while (builder.isLineRequired());
            if (builder.isCompleted()) {
                return builder.getSql();
            }
            throw new IllegalStateException("builder");
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void close() {
        CloseableUtil.close(this.reader);
    }

    protected BufferedReader createBufferedReader() throws IOException {
        FileInputStream is = new FileInputStream(this.sqlFile);
        return new BufferedReader(new InputStreamReader((InputStream)is, this.sqlFileEncoding));
    }

    protected class SqlBuilder {
        protected boolean tokenRequired;
        protected boolean lineRequired;
        protected boolean completed;
        protected StringBuilder buf = new StringBuilder(300);
        protected List<String> wordList = new ArrayList<String>();
        protected GenDialect.SqlBlockContext sqlBlockContext;
        protected boolean lineChanged;

        protected SqlBuilder() {
            this.sqlBlockContext = SqlFileReader.this.dialect.createSqlBlockContext();
        }

        protected void build(SqlFileTokenizer.TokenType tokenType, String token) {
            this.reset();
            if (this.buf.length() == 0) {
                SqlFileReader.this.lineNumber = SqlFileReader.this.lineCount;
            }
            switch (tokenType) {
                case WORD: {
                    this.appendWord(token);
                }
                case QUOTE: 
                case OTHER: {
                    this.appendToken(token);
                    this.requireToken();
                    break;
                }
                case END_OF_LINE: {
                    SqlFileReader.this.endOfLine = true;
                    this.requireLine();
                    break;
                }
                case STATEMENT_DELIMITER: {
                    if (this.isInSqlBlock()) {
                        this.appendToken(token);
                        this.requireToken();
                        break;
                    }
                    this.complete();
                    break;
                }
                case BLOCK_DELIMITER: {
                    if (this.isSqlEmpty()) {
                        this.requireToken();
                        break;
                    }
                    this.complete();
                    break;
                }
                case END_OF_FILE: {
                    SqlFileReader.this.endOfFile = true;
                    this.complete();
                    break;
                }
                default: {
                    this.requireToken();
                }
            }
        }

        protected void reset() {
            SqlFileReader.this.endOfLine = false;
            this.requireToken();
        }

        protected boolean isTokenRequired() {
            return this.tokenRequired;
        }

        protected void requireToken() {
            this.tokenRequired = true;
            this.lineRequired = false;
            this.completed = false;
        }

        protected boolean isLineRequired() {
            return this.lineRequired;
        }

        protected void requireLine() {
            this.lineRequired = true;
            this.tokenRequired = false;
            this.completed = false;
        }

        protected boolean isCompleted() {
            return this.completed;
        }

        protected void complete() {
            this.completed = true;
            this.tokenRequired = false;
            this.lineRequired = false;
        }

        protected void appendWord(String word) {
            this.sqlBlockContext.addKeyword(word);
        }

        protected void appendToken(String token) {
            this.appendWhitespaceIfNecessary();
            this.buf.append(token);
        }

        protected void appendWhitespaceIfNecessary() {
            char lastChar;
            if (!this.lineChanged) {
                return;
            }
            if (this.buf.length() > 0 && !Character.isWhitespace(lastChar = this.buf.charAt(this.buf.length() - 1))) {
                this.buf.append(' ');
            }
            this.lineChanged = false;
        }

        protected void notifyLineChanged() {
            this.lineChanged = true;
        }

        protected boolean isInSqlBlock() {
            return this.sqlBlockContext.isInSqlBlock();
        }

        protected boolean isSqlEmpty() {
            return this.buf.toString().trim().length() == 0;
        }

        protected String getSql() {
            if (!this.completed) {
                throw new IllegalStateException("completed");
            }
            String sql = this.buf.toString().trim();
            return SqlFileReader.this.endOfFile && sql.length() == 0 ? null : sql;
        }
    }
}

