/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.framework.exception.IORuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    protected FileUtil() {
    }

    public static void copy(File src, File dest) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            FileUtil.copyInternal(in, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(in);
                CloseableUtil.close(out);
                throw throwable;
            }
        }
        CloseableUtil.close(in);
        CloseableUtil.close(out);
    }

    public static void append(File src, File dest) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest, true);
            FileUtil.copyInternal(in, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(in);
                CloseableUtil.close(out);
                throw throwable;
            }
        }
        CloseableUtil.close(in);
        CloseableUtil.close(out);
    }

    protected static void copyInternal(FileInputStream in, FileOutputStream out) throws IOException {
        FileChannel src = in.getChannel();
        FileChannel dest = out.getChannel();
        src.transferTo(0L, src.size(), dest);
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean createNewFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File createTempFile(String prefix, String suffix) {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void traverseDirectory(File dir, FilenameFilter filter, Comparator<File> comparator, FileHandler handler) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return;
        }
        Arrays.sort(files, comparator);
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtil.traverseDirectory(file, filter, comparator, handler);
            }
            handler.handle(file);
        }
    }

    public static File createJavaFile(File baseDir, String packageName, String shortClassName) {
        File packageDir = packageName == null ? baseDir : new File(baseDir, packageName.replace('.', File.separatorChar));
        return new File(packageDir, shortClassName + ".java");
    }

    public static interface FileHandler {
        public void handle(File var1);
    }
}

