/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.IllegalInstanceDefRuntimeException;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.deployer.InstanceOuterDef;
import org.seasar.framework.container.deployer.InstancePrototypeDef;
import org.seasar.framework.container.deployer.InstanceRequestDef;
import org.seasar.framework.container.deployer.InstanceSessionDef;
import org.seasar.framework.container.deployer.InstanceSingletonDef;

public class InstanceDefFactory {
    public static final InstanceDef SINGLETON = new InstanceSingletonDef("singleton");
    public static final InstanceDef PROTOTYPE = new InstancePrototypeDef("prototype");
    public static final InstanceDef SESSION = new InstanceSessionDef("session");
    public static final InstanceDef REQUEST = new InstanceRequestDef("request");
    public static final InstanceDef OUTER = new InstanceOuterDef("outer");
    private static Map instanceDefs = new HashMap();

    protected InstanceDefFactory() {
    }

    public static void addInstanceDef(InstanceDef instanceDef) {
        instanceDefs.put(instanceDef.getName(), instanceDef);
    }

    public static boolean existInstanceDef(String name) {
        return instanceDefs.containsKey(name);
    }

    public static InstanceDef getInstanceDef(String name) {
        if (!instanceDefs.containsKey(name)) {
            throw new IllegalInstanceDefRuntimeException(name);
        }
        return (InstanceDef)instanceDefs.get(name);
    }

    static {
        InstanceDefFactory.addInstanceDef(SINGLETON);
        InstanceDefFactory.addInstanceDef(PROTOTYPE);
        InstanceDefFactory.addInstanceDef(SESSION);
        InstanceDefFactory.addInstanceDef(REQUEST);
        InstanceDefFactory.addInstanceDef(OUTER);
    }
}

