/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.TableNotFoundRuntimeException;
import org.seasar.extension.dataset.impl.DataTableImpl;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;

public class DataSetImpl
implements DataSet {
    private ArrayMap tables_ = new CaseInsensitiveMap();

    public int getTableSize() {
        return this.tables_.size();
    }

    public String getTableName(int index) {
        return this.getTable(index).getTableName();
    }

    public DataTable getTable(int index) {
        return (DataTable)this.tables_.get(index);
    }

    public DataTable getTable(String tableName) throws TableNotFoundRuntimeException {
        DataTable table = (DataTable)this.tables_.get((Object)tableName);
        if (table == null) {
            throw new TableNotFoundRuntimeException(tableName);
        }
        return table;
    }

    public DataTable addTable(String tableName) {
        return this.addTable(new DataTableImpl(tableName));
    }

    public DataTable addTable(DataTable table) {
        this.tables_.put((Object)table.getTableName(), (Object)table);
        return table;
    }

    public DataTable removeTable(DataTable table) {
        return this.removeTable(table.getTableName());
    }

    public DataTable removeTable(int index) {
        return (DataTable)this.tables_.remove(index);
    }

    public DataTable removeTable(String tableName) {
        DataTable table = (DataTable)this.tables_.remove((Object)tableName);
        if (table == null) {
            throw new TableNotFoundRuntimeException(tableName);
        }
        return table;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < this.getTableSize(); ++i) {
            buf.append(this.getTable(i));
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)o;
        if (this.getTableSize() != other.getTableSize()) {
            return false;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (this.getTable(i).equals(other.getTable(i))) continue;
            return false;
        }
        return true;
    }
}

