/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.framework.util;

import junit.framework.TestCase;

public class ByteConversionUtilTest extends TestCase {

    public void testToByteConversionUtilTest() throws Exception {
        assertEquals("1", new Byte("100"), ByteConversionUtil.toByte("100"));
    }

    public void testToPrimitiveByteConversionUtilTest() throws Exception {
        assertEquals("1", 100, ByteConversionUtil.toPrimitiveByte("100"));
    }
}