/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoBatchUpdateQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchUpdateQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setName("bbb");
        emp2.setVersion(200);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoBatchUpdateQuery batchUpdateQuery = query;
        AutoBatchUpdateQueryTest.assertEquals((int)2, (int)batchUpdateQuery.getSqls().size());
    }

    public void testOption_default() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(200);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)5, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertTrue((((PreparedSqlParameter)parameters.get(1)).getWrapper().get() == null ? 1 : 0) != 0);
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(4)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)5, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertTrue((((PreparedSqlParameter)parameters.get(0)).getWrapper().get() == null ? 1 : 0) != 0);
        AutoBatchUpdateQueryTest.assertEquals((Object)new BigDecimal(2000), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(4)).getWrapper().get());
    }

    public void testOption_includeVersion() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(200);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setVersionIncluded(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, SALARY = ?, VERSION = ? where ID = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, SALARY = ?, VERSION = ? where ID = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new BigDecimal(2000), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testOption_include() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setSalary(new BigDecimal(200));
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setVersion(200);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setIncludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testOption_exclude() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setSalary(new BigDecimal(200));
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setVersion(200);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setExcludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertEquals((Object)new BigDecimal(200), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchUpdateQueryTest.assertEquals((String)"update EMP set SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchUpdateQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchUpdateQueryTest.assertEquals((Object)new Integer(200), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testIsExecutable() throws Exception {
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setEntities(Collections.emptyList());
        query.prepare();
        AutoBatchUpdateQueryTest.assertFalse((boolean)query.isExecutable());
    }
}

