/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockPreparedStatement;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class PreparedSqlParameterBinderTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testBind() throws Exception {
        MockPreparedStatement preparedStatement = new MockPreparedStatement();
        ArrayList<BasicInParameter> parameters = new ArrayList<BasicInParameter>();
        parameters.add(new BasicInParameter((Wrapper)new StringWrapper("aaa")));
        parameters.add(new BasicInParameter((Wrapper)new BigDecimalWrapper(new BigDecimal(10))));
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder((Query)new MyQuery());
        binder.bind((PreparedStatement)preparedStatement, parameters);
        List<BindValue> bindValues = preparedStatement.bindValues;
        PreparedSqlParameterBinderTest.assertEquals((int)2, (int)bindValues.size());
        BindValue bindValue = bindValues.get(0);
        PreparedSqlParameterBinderTest.assertEquals((int)1, (int)bindValue.getIndex());
        PreparedSqlParameterBinderTest.assertEquals((Object)"aaa", (Object)bindValue.getValue());
        bindValue = bindValues.get(1);
        PreparedSqlParameterBinderTest.assertEquals((int)2, (int)bindValue.getIndex());
        PreparedSqlParameterBinderTest.assertEquals((Object)new BigDecimal(10), (Object)bindValue.getValue());
    }

    protected class MyQuery
    implements Query {
        protected MyQuery() {
        }

        public Sql<?> getSql() {
            return null;
        }

        public Config getConfig() {
            return PreparedSqlParameterBinderTest.this.runtimeConfig;
        }

        public String getClassName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public int getQueryTimeout() {
            return 0;
        }

        public void prepare() {
        }

        public void complete() {
        }
    }
}

