/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.entity;

import java.lang.reflect.Method;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public abstract class AbstractEntityListenerContext<E> {
    protected final EntityType<E> entityType;
    protected final Method method;
    protected final Config config;
    protected E newEntity;

    protected AbstractEntityListenerContext(EntityType<E> entityType, Method method, Config config) {
        AssertionUtil.assertNotNull(entityType, (Object)method, (Object)config);
        this.entityType = entityType;
        this.method = method;
        this.config = config;
    }

    protected boolean isPropertyDefinedInternal(String propertyName) {
        AssertionUtil.assertNotNull(propertyName);
        return this.entityType.getEntityPropertyType(propertyName) != null;
    }

    public EntityType<E> getEntityType() {
        return this.entityType;
    }

    public Method getMethod() {
        return this.method;
    }

    public Config getConfig() {
        return this.config;
    }

    public E getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(E newEntity) {
        if (newEntity == null) {
            throw new DomaNullPointerException("newEntity");
        }
        this.newEntity = newEntity;
    }
}

