/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.GreedyCacheSqlFileRepository;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlFileNotFoundException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.message.Message;

public class JdbcExceptionTest
extends TestCase {
    private final MockConfig config = new MockConfig();

    public void testSqlFileNotFound() throws Exception {
        GreedyCacheSqlFileRepository repository = new GreedyCacheSqlFileRepository();
        try {
            repository.getSqlFile("META-INF/aaa/bbb.sql", (Dialect)new StandardDialect());
            JdbcExceptionTest.fail();
        }
        catch (SqlFileNotFoundException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2011, (Object)e.getMessageResource());
        }
    }

    public void testQuotationNotClosed() throws Exception {
        SqlParser parser = new SqlParser("select * from 'aaa");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2101, (Object)e.getMessageResource());
        }
    }

    public void testBlockCommentNotClosed() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa /*aaa");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2102, (Object)e.getMessageResource());
        }
    }

    public void testElseifCommentNotClosed() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa --elseif bbb");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2103, (Object)e.getMessageResource());
        }
    }

    public void testIfCommentNotFoundForEndComment() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa/*%end*/ ");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2104, (Object)e.getMessageResource());
        }
    }

    public void testIfCommentNotFoundForSecondEndComment() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where/*%if true*//*%end*/ /*%end*/");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2104, (Object)e.getMessageResource());
        }
    }

    public void testIfCommentNotFoundForElseComment() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb = ccc--else ddd = eee");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2105, (Object)e.getMessageResource());
        }
    }

    public void testIfCommentNotFoundForElseifComment() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb = ccc--elseif true--ddd = eee");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2106, (Object)e.getMessageResource());
        }
    }

    public void testElseCommentDuplicated() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where /*%if true*/bbb = ccc--else --else ddd = eee");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2107, (Object)e.getMessageResource());
        }
    }

    public void testElseifCommentFollowsElseComment() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where /*%if true*/bbb = ccc--else ddd = eee --elseif ture--");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2108, (Object)e.getMessageResource());
        }
    }

    public void testOpenedParensNotFound() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where )");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2109, (Object)e.getMessageResource());
        }
    }

    public void testTestLiteralNotFound() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb = /*bbb*/ 'ccc')");
        try {
            parser.parse();
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2110, (Object)e.getMessageResource());
        }
    }

    public void testSqlBuildingFailed() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb = \n/*bbb*/'ccc'");
        SqlNode sqlNode = parser.parse();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath");
        try {
            builder.build(sqlNode);
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2111, (Object)e.getMessageResource());
        }
    }

    public void testBindValueTypeNotIterable() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb in /*bbb*/(1,2,3)");
        SqlNode sqlNode = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("bbb", new Value(Integer.TYPE, (Object)1));
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        try {
            builder.build(sqlNode);
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2112, (Object)e.getMessageResource());
        }
    }

    public void testCollectionOfBindValueContainsNull() throws Exception {
        SqlParser parser = new SqlParser("select * from aaa where bbb in /*bbb*/(1,2,3)");
        SqlNode sqlNode = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("bbb", new Value(List.class, Arrays.asList(1, null)));
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        try {
            builder.build(sqlNode);
            JdbcExceptionTest.fail();
        }
        catch (JdbcException e) {
            System.out.println(e.getMessage());
            JdbcExceptionTest.assertEquals((Object)Message.DOMA2115, (Object)e.getMessageResource());
        }
    }
}

