/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.EntityBuilder;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityBuilderTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testBuild() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        metaData.columns.add(new ColumnMetaData("salary"));
        metaData.columns.add(new ColumnMetaData("version"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "aaa", new BigDecimal(10), 100));
        resultSet.next();
        _Emp entityType = _Emp.getSingletonInternal();
        EntityBuilder builder = new EntityBuilder((Query)new MySelectQuery(), (EntityType)entityType, false);
        Emp emp = (Emp)builder.build((ResultSet)resultSet);
        EntityBuilderTest.assertEquals((Object)new Integer(1), (Object)emp.getId());
        EntityBuilderTest.assertEquals((String)"aaa", (String)emp.getName());
        EntityBuilderTest.assertEquals((Object)new BigDecimal(10), (Object)emp.getSalary());
        EntityBuilderTest.assertEquals((Object)new Integer(100), (Object)emp.getVersion());
    }

    protected class MySelectQuery
    implements SelectQuery {
        protected MySelectQuery() {
        }

        public SelectOptions getOptions() {
            return SelectOptions.get();
        }

        public Config getConfig() {
            return EntityBuilderTest.this.runtimeConfig;
        }

        public String getClassName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public PreparedSql getSql() {
            return null;
        }

        public boolean isResultEnsured() {
            return false;
        }

        public boolean isResultMappingEnsured() {
            return false;
        }

        public int getFetchSize() {
            return 0;
        }

        public int getMaxRows() {
            return 0;
        }

        public int getQueryTimeout() {
            return 0;
        }

        public void prepare() {
        }

        public void complete() {
        }
    }
}

