/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.ByteWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class ByteWrapper
extends AbstractWrapper<Byte>
implements NumberWrapper<Byte> {
    public ByteWrapper() {
    }

    public ByteWrapper(Byte value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        super.set(v.byteValue());
    }

    @Override
    public Byte getDefault() {
        return (byte)0;
    }

    @Override
    public void increment() {
        Byte value = this.getIncrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public void decrement() {
        Byte value = this.getDecrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public Byte getIncrementedValue() {
        Byte value = (Byte)this.doGet();
        if (value != null) {
            return (byte)(value + 1);
        }
        return null;
    }

    @Override
    public Byte getDecrementedValue() {
        Byte value = (Byte)this.doGet();
        if (value != null) {
            return (byte)(value - 1);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof ByteWrapperVisitor) {
            ByteWrapperVisitor v = (ByteWrapperVisitor)visitor;
            return v.visitByteWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

