/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.internal.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchUpdateQuery<E>
extends AutoBatchModifyQuery<E>
implements BatchUpdateQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoBatchUpdateQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.method, this.config, this.callerClassName, this.callerMethodName, this.entities, this.sqls);
        int size = this.entities.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.executionSkipCause = null;
        this.currentEntity = this.entities.get(0);
        this.preUpdate();
        this.prepareIdAndVersionPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareTargetPropertyTypes();
        this.prepareSql();
        this.entities.set(0, this.currentEntity);
        for (int i = 1; i < size; ++i) {
            this.currentEntity = this.entities.get(i);
            this.preUpdate();
            this.prepareSql();
            this.entities.set(i, this.currentEntity);
        }
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void preUpdate() {
        AutoBatchPreUpdateContext context = new AutoBatchPreUpdateContext(this.entityType, this.method, this.config);
        this.entityType.preUpdate(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType p : this.entityType.getEntityPropertyTypes()) {
            if (!p.isUpdatable() || p.isId()) continue;
            if (p.isVersion()) {
                this.targetPropertyTypes.add(p);
                continue;
            }
            if (!this.isTargetPropertyName(p.getName())) continue;
            this.targetPropertyTypes.add(p);
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_UPDATE);
        builder.appendSql("update ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        builder.appendSql(" set ");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(p.getWrapper(this.currentEntity));
            if (p.isVersion() && !this.versionIgnored) {
                builder.appendSql(" + 1");
            }
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            for (EntityPropertyType p : this.idPropertyTypes) {
                builder.appendSql(p.getColumnName());
                builder.appendSql(" = ");
                builder.appendWrapper(p.getWrapper(this.currentEntity));
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (this.idPropertyTypes.size() == 0) {
                builder.appendSql(" where ");
            } else {
                builder.appendSql(" and ");
            }
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.currentEntity));
        }
        PreparedSql sql = builder.build();
        this.sqls.add(sql);
    }

    @Override
    public void incrementVersions() {
        if (this.versionPropertyType != null && !this.versionIgnored) {
            boolean immutable = this.entityType.isImmutable();
            int size = this.entities.size();
            for (int i = 0; i < size; ++i) {
                Object entity = this.entities.get(i);
                if (immutable) {
                    Object newEntity = this.versionPropertyType.incrementAndNewEntity(entity, this.entityType);
                    this.entities.set(i, newEntity);
                    continue;
                }
                this.versionPropertyType.increment(entity);
            }
        }
    }

    @Override
    public void complete() {
        int len = this.entities.size();
        for (int i = 0; i < len; ++i) {
            this.currentEntity = this.entities.get(i);
            this.postUpdate();
            this.entities.set(i, this.currentEntity);
        }
    }

    protected void postUpdate() {
        AutoBatchPostUpdateContext context = new AutoBatchPostUpdateContext(this.entityType, this.method, this.config);
        this.entityType.postUpdate(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoBatchPostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public AutoBatchPostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class AutoBatchPreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public AutoBatchPreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }
}

