/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class ModifyMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue sqlFile;
    protected AnnotationValue queryTimeout;
    protected AnnotationValue ignoreVersion;
    protected AnnotationValue includeVersion;
    protected AnnotationValue excludeNull;
    protected AnnotationValue suppressOptimisticLockException;
    protected AnnotationValue includeUnchanged;
    protected AnnotationValue include;
    protected AnnotationValue exclude;

    protected ModifyMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getSqlFile() {
        return this.sqlFile;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getIgnoreVersion() {
        return this.ignoreVersion;
    }

    public AnnotationValue getIncludeVersion() {
        return this.includeVersion;
    }

    public AnnotationValue getExcludeNull() {
        return this.excludeNull;
    }

    public AnnotationValue getSuppressOptimisticLockException() {
        return this.suppressOptimisticLockException;
    }

    public AnnotationValue getIncludeUnchanged() {
        return this.includeUnchanged;
    }

    public AnnotationValue getInclude() {
        return this.include;
    }

    public AnnotationValue getExclude() {
        return this.exclude;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException("queryTimeout");
        }
        return value;
    }

    public Boolean getIgnoreVersionValue() {
        return AnnotationValueUtil.toBoolean(this.ignoreVersion);
    }

    public Boolean getIncludeVersionValue() {
        return AnnotationValueUtil.toBoolean(this.includeVersion);
    }

    public Boolean getExcludeNullValue() {
        return AnnotationValueUtil.toBoolean(this.excludeNull);
    }

    public Boolean getSuppressOptimisticLockExceptionValue() {
        return AnnotationValueUtil.toBoolean(this.suppressOptimisticLockException);
    }

    public Boolean getIncludeUnchangedValue() {
        return AnnotationValueUtil.toBoolean(this.includeUnchanged);
    }

    public List<String> getIncludeValue() {
        return AnnotationValueUtil.toStringList(this.include);
    }

    public List<String> getExcludeValue() {
        return AnnotationValueUtil.toStringList(this.exclude);
    }

    public boolean getSqlFileValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.sqlFile);
        if (value == null) {
            throw new AptIllegalStateException("sqlFile");
        }
        return value;
    }
}

