/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoUpdateQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoUpdateQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoUpdateQuery updateQuery = query;
        AutoUpdateQueryTest.assertNotNull((Object)updateQuery.getSql());
    }

    public void testOption_default() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        emp.originalStates = new Emp();
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testOption_excludeNull() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setVersion(100);
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setNullExcluded(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoUpdateQueryTest.assertEquals((String)"update EMP set VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoUpdateQueryTest.assertEquals((int)3, (int)parameters.size());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }

    public void testOption_includeVersion() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        emp.originalStates = new Emp();
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setVersionIncluded(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? where ID = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoUpdateQueryTest.assertEquals((int)3, (int)parameters.size());
        AutoUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }

    public void testOption_include() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setSalary(new BigDecimal(200));
        emp.setVersion(100);
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setIncludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoUpdateQueryTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoUpdateQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testOption_exclude() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setSalary(new BigDecimal(200));
        emp.setVersion(100);
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setExcludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoUpdateQueryTest.assertEquals((String)"update EMP set SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoUpdateQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoUpdateQueryTest.assertEquals((Object)new BigDecimal(200), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoUpdateQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
    }

    public void testIsExecutable() throws Exception {
        Emp emp = new Emp();
        emp.originalStates = new Emp();
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoUpdateQueryTest.assertFalse((boolean)query.isExecutable());
    }
}

