/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.UpdateCommand;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoUpdateQuery;
import org.seasar.doma.internal.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.entity.EntityType;

public class UpdateCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setVersion(10);
        emp.originalStates = new Emp();
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int rows = new UpdateCommand((UpdateQuery)query).execute();
        query.complete();
        UpdateCommandTest.assertEquals((int)1, (int)rows);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        UpdateCommandTest.assertEquals((String)"update EMP set NAME = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql);
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        UpdateCommandTest.assertEquals((int)4, (int)bindValues.size());
        UpdateCommandTest.assertEquals((Object)"hoge", (Object)bindValues.get(0).getValue());
        UpdateCommandTest.assertEquals((Object)new Integer(10), (Object)bindValues.get(1).getValue());
        UpdateCommandTest.assertEquals((Object)new Integer(1), (Object)bindValues.get(2).getValue());
        UpdateCommandTest.assertEquals((Object)new Integer(10), (Object)bindValues.get(3).getValue());
    }

    public void testExecute_throwsOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        this.runtimeConfig.dataSource.connection.preparedStatement.updatedRows = 0;
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        UpdateCommand command = new UpdateCommand((UpdateQuery)query);
        try {
            command.execute();
            UpdateCommandTest.fail();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }

    public void testExecute_suppressesOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        this.runtimeConfig.dataSource.connection.preparedStatement.updatedRows = 0;
        AutoUpdateQuery query = new AutoUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setOptimisticLockExceptionSuppressed(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        new UpdateCommand((UpdateQuery)query).execute();
        query.complete();
    }
}

