/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.ScriptTokenType;
import org.seasar.doma.internal.jdbc.command.ScriptTokenizer;

public class ScriptTokenizerTest
extends TestCase {
    private ScriptTokenizer tokenizer;

    public void setUp() throws Exception {
        this.tokenizer = new ScriptTokenizer("/");
    }

    public void testGetToken_endOfLine() {
        this.tokenizer.addLine("aaa");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
    }

    public void testGetToken_endOfFile() {
        this.tokenizer.addLine("aaa");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
        this.tokenizer.addLine(null);
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_FILE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertNull((Object)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_FILE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertNull((Object)this.tokenizer.getToken());
    }

    public void testGetToken_lineComment() {
        this.tokenizer.addLine("aaa -- bbb /* ; ");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)" ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.LINE_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"-- bbb /* ; ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_blockCommentInTwoLines() {
        this.tokenizer.addLine("aaa/*b");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.START_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"/*", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"b", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
        this.tokenizer.addLine("bb*/ccc");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"bb", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"*/", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"ccc", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_blockCommentsInOneLine() {
        this.tokenizer.addLine("aaa/*bbb*/ccc/*ddd*/");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.START_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"/*", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"bbb", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"*/", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"ccc", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.START_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"/*", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"ddd", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_BLOCK_COMMENT, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"*/", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_statementDelimiter() throws Exception {
        this.tokenizer.addLine("select * from aaa; ");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"select", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)" * ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"from", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)" ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.STATEMENT_DELIMITER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)";", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)" ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_blockDelimiter() throws Exception {
        this.tokenizer.addLine("aaa go");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)" ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"go", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
        this.tokenizer.addLine("/ ");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.BLOCK_DELIMITER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"/ ", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_wordAndOther() throws Exception {
        this.tokenizer.addLine("select,");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"select", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.OTHER, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)",", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"", (String)this.tokenizer.getToken());
        this.tokenizer.addLine("bbb");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.WORD, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"bbb", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_quote() throws Exception {
        this.tokenizer.addLine("'aaa'");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.QUOTE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"'aaa'", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }

    public void testGetToken_quoteNotClosed() throws Exception {
        this.tokenizer.addLine("'aaa");
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.QUOTE, (Object)this.tokenizer.nextToken());
        ScriptTokenizerTest.assertEquals((String)"'aaa", (String)this.tokenizer.getToken());
        ScriptTokenizerTest.assertEquals((Object)ScriptTokenType.END_OF_LINE, (Object)this.tokenizer.nextToken());
    }
}

