/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.SQLException;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.ScriptCommand;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockStatement;
import org.seasar.doma.internal.jdbc.query.ScriptQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileScriptQuery;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ScriptException;

public class ScriptCommandTest
extends TestCase {
    public void testExecute() throws Exception {
        SqlFileScriptQuery query = new SqlFileScriptQuery();
        query.setConfig((Config)new MockConfig());
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setScriptFilePath(ScriptFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setBlockDelimiter("");
        query.prepare();
        ScriptCommand command = new ScriptCommand((ScriptQuery)query);
        command.execute();
    }

    public void testExecute_ScriptException() throws Exception {
        MockConfig config = new MockConfig();
        config.dataSource.connection.statement = new MockStatement(){

            @Override
            public boolean execute(String sql) throws SQLException {
                throw new SQLException("mock error.");
            }
        };
        SqlFileScriptQuery query = new SqlFileScriptQuery();
        query.setConfig((Config)config);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setScriptFilePath(ScriptFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setBlockDelimiter("");
        query.setHaltOnError(true);
        query.prepare();
        ScriptCommand command = new ScriptCommand((ScriptQuery)query);
        try {
            command.execute();
            ScriptCommandTest.fail();
        }
        catch (ScriptException expected) {
            System.out.println(expected.getMessage());
        }
    }
}

