/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.Collections;
import java.util.List;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameter;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;

public class CallableSql
implements Sql<CallableSqlParameter> {
    protected final SqlKind kind;
    protected final String rawSql;
    protected final String formattedSql;
    protected final List<CallableSqlParameter> parameters;

    public CallableSql(SqlKind kind, CharSequence rawSql, CharSequence formattedSql, List<? extends CallableSqlParameter> parameters) {
        if (kind == null) {
            throw new DomaNullPointerException("kind");
        }
        if (rawSql == null) {
            throw new DomaNullPointerException("rawSql");
        }
        if (formattedSql == null) {
            throw new DomaNullPointerException("formattedSql");
        }
        if (parameters == null) {
            throw new DomaNullPointerException("parameters");
        }
        this.kind = kind;
        this.rawSql = rawSql.toString().trim();
        this.formattedSql = formattedSql.toString().trim();
        this.parameters = Collections.unmodifiableList(parameters);
    }

    @Override
    public SqlKind getKind() {
        return this.kind;
    }

    @Override
    public String getRawSql() {
        return this.rawSql;
    }

    @Override
    public String getFormattedSql() {
        return this.formattedSql;
    }

    @Override
    public String getSqlFilePath() {
        return null;
    }

    @Override
    public List<CallableSqlParameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.rawSql;
    }
}

