/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.EntityBuilder;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityResultListHandler<E>
implements ResultSetHandler<List<E>> {
    protected final EntityType<E> entityType;

    public EntityResultListHandler(EntityType<E> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    @Override
    public List<E> handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        EntityBuilder<E> builder = new EntityBuilder<E>(query, this.entityType, query.isResultMappingEnsured());
        ArrayList<E> entities = new ArrayList<E>();
        while (resultSet.next()) {
            E entity = builder.build(resultSet);
            entities.add(entity);
        }
        if (query.isResultEnsured() && entities.isEmpty()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(query.getConfig().getExceptionSqlLogType(), sql);
        }
        return entities;
    }
}

