/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.apt.mirror.SequenceGeneratorMirror;
import org.seasar.doma.internal.util.AssertionUtil;

public class SequenceIdGeneratorMeta
implements IdGeneratorMeta {
    protected final SequenceGeneratorMirror sequenceGeneratorMirror;

    public SequenceIdGeneratorMeta(SequenceGeneratorMirror sequenceGeneratorMirror) {
        AssertionUtil.assertNotNull(sequenceGeneratorMirror);
        this.sequenceGeneratorMirror = sequenceGeneratorMirror;
    }

    public String getQualifiedSequenceName() {
        String schemaName;
        StringBuilder buf = new StringBuilder();
        String catalogName = this.sequenceGeneratorMirror.getCatalogValue();
        if (!catalogName.isEmpty()) {
            buf.append(catalogName);
            buf.append(".");
        }
        if (!(schemaName = this.sequenceGeneratorMirror.getCatalogValue()).isEmpty()) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(this.sequenceGeneratorMirror.getSequenceValue());
        return buf.toString();
    }

    public long getInitialValue() {
        return this.sequenceGeneratorMirror.getInitialValueValue();
    }

    public long getAllocationSize() {
        return this.sequenceGeneratorMirror.getAllocationSizeValue();
    }

    @Override
    public String getIdGeneratorClassName() {
        return this.sequenceGeneratorMirror.getImplementerValue().toString();
    }

    @Override
    public <R, P> R accept(IdGeneratorMetaVisitor<R, P> visitor, P p) {
        return visitor.visistSequenceIdGeneratorMeta(this, p);
    }
}

