/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoDeleteQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoDeleteQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp = new Emp();
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoDeleteQuery deleteQuery = query;
        AutoDeleteQueryTest.assertNotNull((Object)deleteQuery.getSql());
    }

    public void testOption_default() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoDeleteQueryTest.assertEquals((int)2, (int)parameters.size());
        AutoDeleteQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoDeleteQueryTest.assertEquals((Object)new Integer(100), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
    }

    public void testOption_ignoreVersion() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setVersionIgnored(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoDeleteQueryTest.assertEquals((int)1, (int)parameters.size());
        AutoDeleteQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
    }
}

