/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import example.entity._Emp;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockConnection;
import org.seasar.doma.internal.jdbc.mock.MockDataSource;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.BuiltinTableIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;

public class BuiltinTableIdGeneratorTest
extends TestCase {
    public void test() throws Exception {
        MockConfig config = new MockConfig();
        config.setDialect((Dialect)new PostgresDialect());
        MockConnection connection = new MockConnection();
        MockConnection connection2 = new MockConnection();
        MockResultSet resultSet2 = connection2.preparedStatement.resultSet;
        resultSet2.rows.add(new RowData(11L));
        final LinkedList<MockConnection> connections = new LinkedList<MockConnection>();
        connections.add(connection);
        connections.add(connection2);
        config.dataSource = new MockDataSource(){

            @Override
            public Connection getConnection() throws SQLException {
                return (Connection)connections.pop();
            }
        };
        BuiltinTableIdGenerator idGenerator = new BuiltinTableIdGenerator();
        idGenerator.setQualifiedTableName("aaa");
        idGenerator.setPkColumnName("PK");
        idGenerator.setPkColumnValue("EMP_ID");
        idGenerator.setValueColumnName("VALUE");
        idGenerator.setInitialValue(1L);
        idGenerator.setAllocationSize(1L);
        idGenerator.initialize();
        IdGenerationConfig idGenerationConfig = new IdGenerationConfig((Config)config, (EntityType)_Emp.getSingletonInternal(), "EMP", "ID");
        Long value = idGenerator.generatePreInsert(idGenerationConfig);
        BuiltinTableIdGeneratorTest.assertEquals((Object)new Long(10L), (Object)value);
        BuiltinTableIdGeneratorTest.assertEquals((String)"update aaa set VALUE = VALUE + ? where PK = ?", (String)connection.preparedStatement.sql);
        BuiltinTableIdGeneratorTest.assertEquals((int)2, (int)connection.preparedStatement.bindValues.size());
        BuiltinTableIdGeneratorTest.assertEquals((String)"select VALUE from aaa where PK = ?", (String)connection2.preparedStatement.sql);
        BuiltinTableIdGeneratorTest.assertEquals((int)1, (int)connection2.preparedStatement.bindValues.size());
    }
}

